/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.PullRequestBranchType;
import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;

public class PullRequestSCMHead
extends SCMHead
implements ChangeRequestSCMHead2 {
    private static final long serialVersionUID = 1L;
    private final String repoOwner;
    private final String repository;
    private final String branchName;
    private final PullRequestBranchType branchType;
    private final String number;
    private final String title;
    private final BranchSCMHead target;
    private final SCMHeadOrigin origin;
    private final ChangeRequestCheckoutStrategy strategy;

    public PullRequestSCMHead(String name, String repoOwner, String repository, String branchName, PullRequestBranchType branchType, String number, String title, BranchSCMHead target, SCMHeadOrigin origin, ChangeRequestCheckoutStrategy strategy) {
        super(name);
        this.repoOwner = repoOwner;
        this.repository = repository;
        this.branchName = branchName;
        this.branchType = branchType;
        this.number = number;
        this.title = title;
        this.target = target;
        this.origin = origin;
        this.strategy = strategy;
    }

    public PullRequestSCMHead(String name, String repoOwner, String repository, String branchName, BitbucketPullRequest pr, SCMHeadOrigin origin, ChangeRequestCheckoutStrategy strategy) {
        this(name, repoOwner, repository, branchName, pr.getSource().getBranchType(), pr.getId(), pr.getTitle(), new BranchSCMHead(pr.getDestination().getBranch().getName()), origin, strategy);
    }

    public String getPronoun() {
        return Messages.PullRequestSCMHead_Pronoun();
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getBranchName() {
        return this.branchName;
    }

    @NonNull
    public String getId() {
        return this.number;
    }

    public String getTitle() {
        return this.title;
    }

    @NonNull
    public SCMHead getTarget() {
        return this.target;
    }

    @NonNull
    public ChangeRequestCheckoutStrategy getCheckoutStrategy() {
        return this.strategy;
    }

    @NonNull
    public String getOriginName() {
        return this.branchName;
    }

    @NonNull
    public SCMHeadOrigin getOrigin() {
        return this.origin == null ? SCMHeadOrigin.DEFAULT : this.origin;
    }

    public PullRequestBranchType getBranchType() {
        return this.branchType;
    }
}

