/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.buildstatus;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.api.buildstatus.BitbucketBuildStatusNotifier;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerBuildStatus;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

@Extension
public class ServerBuildStatusNotifier
implements BitbucketBuildStatusNotifier {
    private static final String API_COMMIT_STATUS_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/commits/{hash}/builds";

    @Override
    public void sendBuildStatus(@NonNull BitbucketBuildStatus status, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        BitbucketServerBuildStatus newStatus = new BitbucketServerBuildStatus(status);
        newStatus.setName(StringUtils.abbreviate((String)newStatus.getName(), (int)255));
        String key = status.getKey();
        if (StringUtils.length((CharSequence)key) > 255) {
            newStatus.setKey(StringUtils.substring((String)key, (int)0, (int)222) + "/" + DigestUtils.md5Hex((String)key));
        }
        String url = UriTemplate.fromTemplate((String)API_COMMIT_STATUS_PATH).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).set("hash", (Object)newStatus.getHash()).expand();
        client.post(url, JsonParser.toString(newStatus));
    }

    @Override
    public boolean isApplicable(@NonNull EndpointType type) {
        return type == EndpointType.SERVER;
    }
}

