/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class JsonParser {
    private static final JsonMapper mapper = JsonParser.createMapper();

    public static <T> T toJava(String data, Class<T> type) throws IOException {
        return JsonParser.toJava(new StringReader(data), type);
    }

    public static <T> T toJava(InputStream data, Class<T> type) throws IOException {
        return JsonParser.toJava(new InputStreamReader(data, StandardCharsets.UTF_8), type);
    }

    public static <T> T toJava(Reader data, Class<T> type) throws IOException {
        return (T)mapper.readValue(data, type);
    }

    public static <T> T toJava(String data, TypeReference<T> type) throws IOException {
        return (T)mapper.readValue(data, type);
    }

    public static String toString(Object value) throws IOException {
        return mapper.writeValueAsString(value);
    }

    public static JsonNode toJson(String value) throws IOException {
        return mapper.readTree(value);
    }

    private static JsonMapper createMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().defaultDateFormat((DateFormat)new StdDateFormat())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    }
}

