/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudWebhookPayload;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.AbstractWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud.CloudPREvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.RestrictedSince;
import java.util.List;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.collections4.MultiValuedMap;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="933.3.0")
public class CloudPullRequestWebhookProcessor
extends AbstractWebhookProcessor {
    private static final List<String> supportedEvents = List.of(HookEventType.PULL_REQUEST_CREATED.getKey(), HookEventType.PULL_REQUEST_DECLINED.getKey(), HookEventType.PULL_REQUEST_MERGED.getKey(), HookEventType.PULL_REQUEST_UPDATED.getKey());

    @Override
    public boolean canHandle(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        return headers.containsKey("X-Event-Key") && headers.containsKey("X-Request-UUID") && supportedEvents.contains(headers.get("X-Event-Key")) && !parameters.containsKey((Object)"server_url");
    }

    @Override
    @NonNull
    public String getServerURL(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        return "https://bitbucket.org";
    }

    @Override
    public void process(@NonNull String hookEventType, @NonNull String payload, @NonNull Map<String, Object> context, @NonNull BitbucketEndpoint endpoint) {
        HookEventType hookEvent = HookEventType.fromString(hookEventType);
        BitbucketPullRequestEvent pull = BitbucketCloudWebhookPayload.pullRequestEventFromPayload(payload);
        if (pull != null) {
            this.notifyEvent(new CloudPREvent(switch (hookEvent) {
                case HookEventType.PULL_REQUEST_CREATED -> SCMEvent.Type.CREATED;
                case HookEventType.PULL_REQUEST_DECLINED, HookEventType.PULL_REQUEST_MERGED -> SCMEvent.Type.REMOVED;
                default -> SCMEvent.Type.UPDATED;
            }, pull, this.getOrigin(context), hookEvent), BitbucketSCMSource.getEventDelaySeconds());
        }
    }
}

