/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import com.cloudbees.hudson.plugins.folder.Messages;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.TopLevelItemDescriptor;
import hudson.views.ViewsTabBar;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.DefaultScriptInvoker;
import org.kohsuke.stapler.jelly.JellyClassTearOff;

public abstract class AbstractFolderDescriptor
extends TopLevelItemDescriptor
implements IconSpec {
    protected AbstractFolderDescriptor(Class<? extends AbstractFolder> clazz) {
        super(clazz);
    }

    protected AbstractFolderDescriptor() {
    }

    public String getDisplayName() {
        return Messages.Folder_DisplayName();
    }

    public String getCategoryId() {
        return "nested-projects";
    }

    public List<AbstractFolderPropertyDescriptor> getPropertyDescriptors() {
        return AbstractFolderPropertyDescriptor.getApplicableDescriptors(this.clazz.asSubclass(AbstractFolder.class));
    }

    public List<FolderHealthMetricDescriptor> getHealthMetricDescriptors() {
        ArrayList<FolderHealthMetricDescriptor> r = new ArrayList<FolderHealthMetricDescriptor>();
        for (FolderHealthMetricDescriptor d : FolderHealthMetricDescriptor.all()) {
            if (!d.isApplicable(this.clazz.asSubclass(AbstractFolder.class))) continue;
            r.add(d);
        }
        return r;
    }

    public List<FolderIconDescriptor> getIconDescriptors() {
        AbstractFolder folder;
        ArrayList<FolderIconDescriptor> r = new ArrayList<FolderIconDescriptor>();
        for (FolderIconDescriptor p : FolderIconDescriptor.all()) {
            if (!p.isApplicable(this.clazz.asSubclass(AbstractFolder.class))) continue;
            r.add(p);
        }
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null && (folder = (AbstractFolder)((Object)request.findAncestorObject(AbstractFolder.class))) != null) {
            return DescriptorVisibilityFilter.apply((Object)((Object)folder), r);
        }
        return r;
    }

    public String getDescription() {
        Stapler stapler = Stapler.getCurrent();
        if (stapler != null) {
            try {
                WebApp webapp = WebApp.getCurrent();
                MetaClass meta = webapp.getMetaClass((Object)this);
                Script s = (Script)((JellyClassTearOff)meta.loadTearOff(JellyClassTearOff.class)).findScript("newInstanceDetail");
                if (s == null) {
                    return "";
                }
                DefaultScriptInvoker dsi = new DefaultScriptInvoker();
                StringWriter sw = new StringWriter();
                XMLOutput xml = dsi.createXMLOutput((Writer)sw, true);
                dsi.invokeScript(Stapler.getCurrentRequest(), Stapler.getCurrentResponse(), s, (Object)this, xml);
                return sw.toString();
            }
            catch (Exception e) {
                Logger.getLogger(this.clazz.getName()).log(Level.WARNING, e.getMessage(), e);
                return "";
            }
        }
        return "";
    }

    public String getIconFilePathPattern() {
        return "plugin/cloudbees-folder/images/:size/folder.png";
    }

    public String getIconClassName() {
        return "icon-folder";
    }

    public boolean isIconConfigurable() {
        return this.getIconDescriptors().size() > 1;
    }

    public boolean isTabBarConfigurable() {
        return Jenkins.getActiveInstance().getDescriptorList(ViewsTabBar.class).size() > 1;
    }

    public boolean isLookAndFeelConfigurable(AbstractFolder<?> folder) {
        return this.isIconConfigurable() || this.isTabBarConfigurable() && folder.getFolderViews().isTabBarModifiable() || folder.getViews().size() > 1 && folder.getFolderViews().isPrimaryModifiable();
    }
}

