/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.DefaultOrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.cloudbees.hudson.plugins.folder.computed.Messages;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategyDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.ResourceList;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.SubTask;
import hudson.security.ACL;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.DescribableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.util.TimeDuration;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.io.FileUtils;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class ComputedFolder<I extends TopLevelItem>
extends AbstractFolder<I>
implements BuildableItem,
Queue.FlyweightTask {
    private static final Logger LOGGER = Logger.getLogger(ComputedFolder.class.getName());
    private OrphanedItemStrategy orphanedItemStrategy;
    private DescribableList<Trigger<?>, TriggerDescriptor> triggers;
    @CheckForNull
    private transient FolderComputation<I> computation;

    protected ComputedFolder(ItemGroup parent, String name) {
        super(parent, name);
        this.init();
    }

    @Override
    protected final void init() {
        super.init();
        if (this.orphanedItemStrategy == null) {
            this.orphanedItemStrategy = new DefaultOrphanedItemStrategy(true, "0", "0");
        }
        if (this.triggers == null) {
            this.triggers = new DescribableList((Saveable)this);
        } else {
            this.triggers.setOwner((Saveable)this);
        }
        for (Trigger t : this.triggers) {
            t.start((Item)this, Items.currentlyUpdatingByXml());
        }
        this.loadComputation();
    }

    protected abstract void computeChildren(ChildObserver<I> var1, TaskListener var2) throws IOException, InterruptedException;

    protected Collection<I> orphanedItems(Collection<I> orphaned, TaskListener listener) throws IOException, InterruptedException {
        return this.getOrphanedItemStrategy().orphanedItems(this, orphaned, listener);
    }

    final void updateChildren(TaskListener listener) throws IOException, InterruptedException {
        final String fullName = this.getFullName();
        LOGGER.log(Level.FINE, "updating {0}", fullName);
        final HashMap orphaned = new HashMap(this.items);
        final HashSet observed = new HashSet();
        this.computeChildren(new ChildObserver<I>(){

            @Override
            public I shouldUpdate(String name) {
                TopLevelItem existing = (TopLevelItem)orphaned.remove(name);
                LOGGER.log(Level.FINE, "{0}: existing {1}: {2}", new Object[]{fullName, name, existing});
                return existing;
            }

            @Override
            public boolean mayCreate(String name) {
                boolean r = observed.add(name);
                LOGGER.log(Level.FINE, "{0}: may create {1}? {2}", new Object[]{fullName, name, r});
                return r;
            }

            @Override
            public void created(I child) {
                LOGGER.log(Level.FINE, "{0}: created {1}", new Object[]{fullName, child});
                String name = child.getName();
                if (!observed.contains(name)) {
                    throw new IllegalStateException("Did not call mayCreate, or used the wrong Item.name for " + child + " with name " + name + " among " + observed);
                }
                child.onCreatedFromScratch();
                try {
                    child.save();
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, "Failed to save " + child, x);
                }
                ComputedFolder.this.items.put(name, child);
                Jenkins j = Jenkins.getInstance();
                if (j != null) {
                    j.rebuildDependencyGraphAsync();
                }
                ItemListener.fireOnCreated(child);
            }
        }, listener);
        if (!orphaned.isEmpty()) {
            LOGGER.log(Level.FINE, "{0}: orphaned {1}", new Object[]{fullName, orphaned});
            for (TopLevelItem existing : this.orphanedItems(orphaned.values(), listener)) {
                LOGGER.log(Level.FINE, "{0}: deleting {1}", new Object[]{fullName, existing});
                existing.delete();
            }
        }
        LOGGER.log(Level.FINE, "finished updating {0}", fullName);
    }

    private synchronized void loadComputation() {
        try {
            FileUtils.forceMkdir((File)this.getComputationDir());
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        this.computation = this.createComputation(null);
        XmlFile file = this.computation.getDataFile();
        if (file != null && file.exists()) {
            try {
                file.unmarshal(this.computation);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + file, e);
            }
        }
    }

    @Override
    @RequirePOST
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.doConfigSubmit(req, rsp);
        this.scheduleBuild();
    }

    @Override
    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.orphanedItemStrategy = (OrphanedItemStrategy)((Object)req.bindJSON(OrphanedItemStrategy.class, json.getJSONObject("orphanedItemStrategy")));
        for (Trigger t : this.triggers) {
            t.stop();
        }
        this.triggers.rebuild(req, json, Trigger.for_((Item)this));
        for (Trigger t : this.triggers) {
            t.start((Item)this, true);
        }
    }

    public Map<TriggerDescriptor, Trigger<?>> getTriggers() {
        return this.triggers.toMap();
    }

    public void addTrigger(Trigger trigger) {
        Trigger old = (Trigger)this.triggers.get((Descriptor)trigger.getDescriptor());
        if (old != null) {
            old.stop();
            this.triggers.remove((Object)old);
        }
        this.triggers.add((Object)trigger);
        trigger.start((Item)this, true);
    }

    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>(super.getActions());
        for (Trigger trigger : this.triggers) {
            actions.addAll(trigger.getProjectActions());
        }
        return actions;
    }

    public boolean isBuildable() {
        return true;
    }

    @RequirePOST
    public HttpResponse doBuild(@QueryParameter TimeDuration delay) {
        this.checkPermission(BUILD);
        if (!this.isBuildable()) {
            throw HttpResponses.error((int)500, (Throwable)new IOException(this.getFullName() + " cannot be recomputed"));
        }
        this.scheduleBuild2(delay == null ? 0 : delay.getTime(), new Action[]{new CauseAction((Cause)new Cause.UserIdCause())});
        return HttpResponses.forwardToPreviousPage();
    }

    @CheckForNull
    public Queue.Item scheduleBuild2(int quietPeriod, Action ... actions) {
        if (!this.isBuildable()) {
            return null;
        }
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return null;
        }
        return j.getQueue().schedule2((Queue.Task)this, quietPeriod, Arrays.asList(actions)).getItem();
    }

    public boolean scheduleBuild() {
        return this.scheduleBuild2(0, new Action[0]) != null;
    }

    public boolean scheduleBuild(Cause c) {
        return this.scheduleBuild2(0, new Action[]{new CauseAction(c)}) != null;
    }

    public boolean scheduleBuild(int quietPeriod) {
        return this.scheduleBuild2(quietPeriod, new Action[0]) != null;
    }

    public boolean scheduleBuild(int quietPeriod, Cause c) {
        return this.scheduleBuild2(quietPeriod, new Action[]{new CauseAction(c)}) != null;
    }

    public boolean isBuildBlocked() {
        return this.getCauseOfBlockage() != null;
    }

    @Deprecated
    public String getWhyBlocked() {
        CauseOfBlockage causeOfBlockage = this.getCauseOfBlockage();
        return causeOfBlockage == null ? null : causeOfBlockage.getShortDescription();
    }

    public CauseOfBlockage getCauseOfBlockage() {
        FolderComputation<I> c = this.computation;
        if (c != null && c.isBuilding()) {
            return CauseOfBlockage.fromMessage((Localizable)Messages._ComputedFolder_already_computing());
        }
        return null;
    }

    public void checkAbortPermission() {
        this.checkPermission(CANCEL);
    }

    public boolean hasAbortPermission() {
        return this.hasPermission(CANCEL);
    }

    public boolean isConcurrentBuild() {
        return false;
    }

    public Collection<? extends SubTask> getSubTasks() {
        return Collections.singleton(this);
    }

    public Authentication getDefaultAuthentication() {
        return ACL.SYSTEM;
    }

    public Authentication getDefaultAuthentication(Queue.Item item) {
        return this.getDefaultAuthentication();
    }

    public Label getAssignedLabel() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return null;
        }
        return j.getSelfLabel();
    }

    public Node getLastBuiltOn() {
        return Jenkins.getInstance();
    }

    public long getEstimatedDuration() {
        return this.computation == null ? -1L : this.computation.getEstimatedDuration();
    }

    public final FolderComputation<I> createExecutable() throws IOException {
        FolderComputation<I> c = this.createComputation(this.computation);
        this.computation = c;
        return c;
    }

    @Nonnull
    protected FolderComputation<I> createComputation(@CheckForNull FolderComputation<I> previous) {
        return new FolderComputation<I>(this, previous);
    }

    public Queue.Task getOwnerTask() {
        return this;
    }

    public Object getSameNodeConstraint() {
        return null;
    }

    public ResourceList getResourceList() {
        return ResourceList.EMPTY;
    }

    protected File getComputationDir() {
        return new File(this.getRootDir(), "computation");
    }

    @CheckForNull
    public FolderComputation<I> getComputation() {
        return this.computation;
    }

    @Override
    protected String renameBlocker() {
        FolderComputation<I> comp = this.getComputation();
        if (comp != null && comp.isBuilding()) {
            return "Recomputation is currently in progress";
        }
        return super.renameBlocker();
    }

    @NonNull
    public OrphanedItemStrategy getOrphanedItemStrategy() {
        return this.orphanedItemStrategy;
    }

    @Restricted(value={DoNotUse.class})
    @NonNull
    public List<OrphanedItemStrategyDescriptor> getOrphanedItemStrategyDescriptors() {
        ArrayList<OrphanedItemStrategyDescriptor> result = new ArrayList<OrphanedItemStrategyDescriptor>();
        for (OrphanedItemStrategyDescriptor descriptor : ExtensionList.lookup(OrphanedItemStrategyDescriptor.class)) {
            if (!descriptor.isApplicable(((Object)((Object)this)).getClass())) continue;
            result.add(descriptor);
        }
        return result;
    }
}

