/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.CommandLauncher;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerConnectorDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.command_launcher.Messages;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.SystemCommandLanguage;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class CommandConnector
extends ComputerConnector {
    public final String command;

    @DataBoundConstructor
    public CommandConnector(String command) {
        this.command = command;
        ScriptApproval.get().configuring(command, SystemCommandLanguage.get(), ApprovalContext.create().withCurrentUser(), Stapler.getCurrentRequest() == null);
    }

    private Object readResolve() {
        ScriptApproval.get().configuring(this.command, SystemCommandLanguage.get(), ApprovalContext.create(), true);
        return this;
    }

    public CommandLauncher launch(String host, TaskListener listener) throws IOException, InterruptedException {
        return new CommandLauncher(new EnvVars(new String[]{"SLAVE", host, "AGENT", host}), this.command);
    }

    @Extension
    @Symbol(value={"command"})
    public static class DescriptorImpl
    extends ComputerConnectorDescriptor {
        public ComputerConnector newInstance(@Nullable StaplerRequest req, @NonNull JSONObject formData) throws Descriptor.FormException {
            CommandConnector instance = (CommandConnector)super.newInstance(req, formData);
            if (formData.get("oldCommand") != null) {
                boolean approveIfAdmin;
                String oldCommand = formData.getString("oldCommand");
                boolean bl = approveIfAdmin = !StringUtils.equals((String)oldCommand, (String)instance.command);
                if (approveIfAdmin) {
                    ScriptApproval.get().configuring(instance.command, SystemCommandLanguage.get(), ApprovalContext.create().withCurrentUser(), true);
                }
            }
            return instance;
        }

        public String getDisplayName() {
            return Messages.CommandLauncher_displayName();
        }

        public FormValidation doCheckCommand(@QueryParameter String value, @QueryParameter String oldCommand) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.CommandLauncher_NoLaunchCommand());
            }
            return ScriptApproval.get().checking(value, SystemCommandLanguage.get(), !StringUtils.equals((String)value, (String)oldCommand));
        }
    }
}

