/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.configprovider.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Describable;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class Config
implements Serializable,
Describable<Config> {
    public final String id;
    public final String name;
    public final String comment;
    public final String content;
    private String providerId;

    public Config(String id, String name, String comment, String content) {
        this.id = id == null ? String.valueOf(System.currentTimeMillis()) : id;
        this.name = name;
        this.comment = comment;
        this.content = content;
    }

    public Config(@NonNull Config config) {
        this(config.id, config.name, config.comment, config.content, config.providerId);
    }

    public Config(@NonNull String id, String name, String comment, String content, @NonNull String providerId) {
        if (id == null) {
            throw new IllegalArgumentException("id can NOT be null");
        }
        if (providerId == null) {
            throw new IllegalArgumentException("providerId can NOT be null");
        }
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.content = content;
        this.providerId = providerId;
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.getActiveInstance().getDescriptorOrDie(this.getClass());
    }

    public ConfigProvider getProvider() {
        return this.getDescriptor();
    }

    public String getProviderId() {
        return this.providerId;
    }

    @DataBoundSetter
    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": id=" + this.id + ", name=" + this.name + ", providerId=" + this.providerId + "]";
    }
}

