/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.Job;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import jenkins.model.TransientActionFactory;
import org.jenkinsci.plugins.configfiles.ConfigFilesAction;

@Extension
public class ConfigFilesActionFactory
extends TransientActionFactory<Job> {
    public Class<Job> type() {
        return Job.class;
    }

    @Nonnull
    public Collection<? extends Action> createFor(@Nonnull Job job) {
        if (job instanceof FreeStyleProject || this.isMavenJob(job)) {
            return Collections.singletonList(new ConfigFilesAction(job));
        }
        return Collections.emptyList();
    }

    private boolean isMavenJob(Job job) {
        try {
            Class<?> mvnJobClass = Class.forName("hudson.maven.MavenModuleSet", false, job.getClass().getClassLoader());
            return mvnJobClass.isAssignableFrom(job.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

