/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigByNameComparator;
import org.jenkinsci.plugins.configfiles.ConfigFileStore;
import org.jenkinsci.plugins.configfiles.ConfigProviderComparator;
import org.jenkinsci.plugins.configfiles.Messages;

@Extension(ordinal=5.0)
@Symbol(value={"globalConfigFiles"})
public class GlobalConfigFiles
extends GlobalConfiguration
implements ConfigFileStore {
    private static Comparator<Config> COMPARATOR = new Comparator<Config>(){

        @Override
        public int compare(Config o1, Config o2) {
            return o1.id.compareTo(o2.id);
        }
    };
    private static ConfigProviderComparator CONFIGPROVIDER_COMPARATOR = new ConfigProviderComparator();
    private Collection<Config> configs = new TreeSet<Config>(COMPARATOR);

    public static GlobalConfigFiles get() {
        GlobalConfigFiles instance = (GlobalConfigFiles)Jenkins.getActiveInstance().getExtensionList(GlobalConfigFiles.class).get(GlobalConfigFiles.class);
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public void migrate() {
        ExtensionList<ConfigProvider> allProviders = ConfigProvider.all();
        for (ConfigProvider p : allProviders) {
            for (Config c : ((AbstractConfigProviderImpl)p).getConfigs().values()) {
                Object converted = ((AbstractConfigProviderImpl)p).convert(c);
                this.configs.add((Config)converted);
            }
        }
        if (this.configs.size() > 0) {
            this.save();
            for (ConfigProvider p : allProviders) {
                p.clearOldDataStorage();
            }
        } else {
            this.load();
        }
    }

    @Override
    public Map<ConfigProvider, Collection<Config>> getGroupedConfigs() {
        TreeMap<ConfigProvider, Collection<Config>> grouped = new TreeMap<ConfigProvider, Collection<Config>>(CONFIGPROVIDER_COMPARATOR);
        for (Config config : this.configs) {
            ArrayList<Config> configs = (ArrayList<Config>)grouped.get((Object)config.getProvider());
            if (configs == null) {
                configs = new ArrayList<Config>();
                grouped.put(config.getProvider(), configs);
            }
            configs.add(config);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            List value = (List)entry.getValue();
            Collections.sort(value, ConfigByNameComparator.INSTANCE);
        }
        return grouped;
    }

    @Override
    public Collection<Config> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Collection<Config> configs) {
        this.configs = configs;
    }

    @Override
    public Collection<Config> getConfigs(Class<? extends Descriptor> descriptor) {
        ArrayList<Config> cs = new ArrayList<Config>();
        for (Config c : this.configs) {
            if (!((Object)((Object)c.getDescriptor())).getClass().equals(descriptor)) continue;
            cs.add(c);
        }
        return cs;
    }

    @Override
    public Config getById(String id) {
        if (id != null) {
            for (Config c : this.configs) {
                if (!id.equals(c.id)) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public void save(Config config) {
        this.configs.remove(config);
        this.configs.add(config);
        this.save();
    }

    @Override
    public void remove(String id) {
        Config c = this.getById(id);
        if (c != null) {
            this.configs.remove(c);
            this.save();
        }
    }

    public String getDisplayName() {
        return Messages.display_name();
    }

    private Object readResolve() {
        if (!(this.configs instanceof TreeSet)) {
            TreeSet<Config> newConfigs = new TreeSet<Config>(COMPARATOR);
            newConfigs.addAll(this.configs);
            this.configs = newConfigs;
        }
        return this;
    }
}

