/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.builder;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFile;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFileUtil;
import org.jenkinsci.plugins.configfiles.buildwrapper.Messages;
import org.jenkinsci.plugins.configfiles.common.CleanTempFilesAction;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConfigFileBuildStep
extends Builder
implements Serializable {
    private static final long serialVersionUID = -5623878268985950032L;
    private List<ManagedFile> managedFiles = new ArrayList<ManagedFile>();

    @DataBoundConstructor
    public ConfigFileBuildStep(List<ManagedFile> managedFiles) {
        this.managedFiles = managedFiles;
    }

    public List<ManagedFile> getManagedFiles() {
        return this.managedFiles;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (build.getWorkspace() == null) {
            throw new IllegalStateException("the workspace does not yet exist, can't provision config files - maybe slave is offline?");
        }
        ArrayList<String> tempFiles = new ArrayList<String>();
        Map<ManagedFile, FilePath> file2Path = ManagedFileUtil.provisionConfigFiles(this.managedFiles, null, build, build.getWorkspace(), (TaskListener)listener, tempFiles);
        for (String tempFile : tempFiles) {
            build.addAction((Action)new CleanTempFilesAction(tempFile));
        }
        build.addAction((Action)new CleanTempFilesAction(file2Path));
        return true;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return Messages.display_name();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

