/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.job;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.mvn.SettingsProvider;
import jenkins.mvn.SettingsProviderDescriptor;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ConfigFileManager;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.common.CleanTempFilesAction;
import org.jenkinsci.plugins.configfiles.maven.MavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.job.Messages;
import org.jenkinsci.plugins.configfiles.maven.job.SimpleEnvironment;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.jenkinsci.plugins.configfiles.maven.security.ServerCredentialMapping;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class MvnSettingsProvider
extends SettingsProvider {
    private static final Logger LOGGER = Logger.getLogger(MvnSettingsProvider.class.getName());
    private String settingsConfigId;

    @Deprecated
    public MvnSettingsProvider() {
    }

    @DataBoundConstructor
    public MvnSettingsProvider(String settingsConfigId) {
        this.settingsConfigId = settingsConfigId;
    }

    public String getSettingsConfigId() {
        return this.settingsConfigId;
    }

    public void setSettingsConfigId(String settingsConfigId) {
        this.settingsConfigId = settingsConfigId;
    }

    public FilePath supplySettings(AbstractBuild<?, ?> build, TaskListener listener) {
        if (StringUtils.isNotBlank((String)this.settingsConfigId)) {
            Object c = ConfigFiles.getByIdOrNull(build.getRootBuild(), this.settingsConfigId);
            if (c == null) {
                String msg = "your Apache Maven build is setup to use a config with id " + this.settingsConfigId + " but can not find the config";
                listener.getLogger().println("ERROR: " + msg);
                throw new IllegalStateException(msg);
            }
            MavenSettingsConfig config = c instanceof MavenSettingsConfig ? (MavenSettingsConfig)c : new MavenSettingsConfig(((Config)c).id, ((Config)c).name, ((Config)c).comment, ((Config)c).content, MavenSettingsConfig.isReplaceAllDefault, null);
            listener.getLogger().println("using settings config with name " + config.name);
            listener.getLogger().println("Replacing all maven server entries not found in credentials list is " + config.getIsReplaceAll());
            if (StringUtils.isNotBlank((String)config.content)) {
                try {
                    FilePath workspace = build.getWorkspace();
                    if (workspace != null) {
                        FilePath workDir = ConfigFileManager.tempDir(workspace);
                        String fileContent = config.content;
                        List<ServerCredentialMapping> serverCredentialMappings = config.getServerCredentialMappings();
                        Map<String, StandardUsernameCredentials> resolvedCredentials = CredentialsHelper.resolveCredentials(build, serverCredentialMappings, listener);
                        Boolean isReplaceAll = config.getIsReplaceAll();
                        if (!resolvedCredentials.isEmpty()) {
                            ArrayList<String> tempFiles = new ArrayList<String>();
                            fileContent = CredentialsHelper.fillAuthentication(fileContent, isReplaceAll, resolvedCredentials, workDir, tempFiles);
                            for (String tempFile : tempFiles) {
                                build.addAction((Action)new CleanTempFilesAction(tempFile));
                            }
                        }
                        FilePath f = workspace.createTextTempFile("settings", ".xml", fileContent, false);
                        LOGGER.log(Level.FINE, "Create {0}", new Object[]{f});
                        build.getEnvironments().add((Object)new SimpleEnvironment("MVN_SETTINGS", f.getRemote()));
                        build.addAction((Action)new CleanTempFilesAction(f.getRemote()));
                        return f;
                    }
                    listener.getLogger().println("ERROR: can't supply maven settings, workspace is null / slave seems not contected...");
                }
                catch (Exception e) {
                    throw new IllegalStateException("the settings.xml could not be supplied for the current build: " + e.getMessage(), e);
                }
            }
        }
        return null;
    }

    @Extension(ordinal=10.0)
    public static class DescriptorImpl
    extends SettingsProviderDescriptor {
        public String getDisplayName() {
            return Messages.MvnSettingsProvider_ProvidedSettings();
        }

        public ListBoxModel doFillSettingsConfigIdItems(@AncestorInPath ItemGroup context) {
            ListBoxModel items = new ListBoxModel();
            items.add(Messages.MvnSettingsProvider_PleaseSelect(), "");
            for (Config config : ConfigFiles.getConfigsInContext(context, MavenSettingsConfig.MavenSettingsConfigProvider.class)) {
                items.add(config.name, config.id);
            }
            return items;
        }
    }
}

