/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.security;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.configfiles.maven.security.MavenServerIdRequirement;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ServerCredentialMapping
extends AbstractDescribableImpl<ServerCredentialMapping>
implements Serializable {
    private final String serverId;
    private final String credentialsId;
    private static final DescriptorImpl DESCIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public ServerCredentialMapping(String serverId, String credentialsId) {
        this.serverId = serverId;
        this.credentialsId = credentialsId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public Descriptor<ServerCredentialMapping> getDescriptor() {
        return DESCIPTOR;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ServerCredentialMapping> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String serverId) {
            Jenkins _context;
            Object object = _context = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getActiveInstance();
            if (_context == null || !_context.hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(serverId);
            }
            List<Object> domainRequirements = Collections.emptyList();
            if (StringUtils.isNotBlank((String)serverId)) {
                domainRequirements = Collections.singletonList(new MavenServerIdRequirement(serverId));
            }
            return new StandardUsernameListBoxModel().includeAs(context instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, context, StandardUsernameCredentials.class, domainRequirements).includeCurrentValue(serverId);
        }

        public String getDisplayName() {
            return "";
        }
    }
}

