/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.properties;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.properties.security.CredentialsHelper;
import org.jenkinsci.plugins.configfiles.properties.security.HasPropertyCredentialMappings;

public abstract class AbstractPropertiesProvider
extends AbstractConfigProviderImpl {
    @Override
    public ContentType getContentType() {
        return ContentType.DefinedType.PROPERTIES;
    }

    @Override
    public String supplyContent(Config configFile, Run<?, ?> build, FilePath workDir, TaskListener listener, List<String> tempFiles) throws IOException {
        HasPropertyCredentialMappings settings = (HasPropertyCredentialMappings)((Object)configFile);
        Map<String, StandardUsernameCredentials> resolvedCredentials = CredentialsHelper.resolveCredentials(build, settings.getPropertiesCredentialMappings(), listener);
        Boolean isReplaceAll = settings.getIsReplaceAll();
        String fileContent = super.supplyContent(configFile, build, workDir, listener, tempFiles);
        if (!resolvedCredentials.isEmpty()) {
            try {
                fileContent = CredentialsHelper.fillAuthentication(fileContent, isReplaceAll, resolvedCredentials);
            }
            catch (Exception exception) {
                throw new IOException("[ERROR] could not insert credentials into the settings file " + configFile, exception);
            }
        }
        return fileContent;
    }
}

