/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.properties.security;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.configfiles.properties.security.PropertyKeyRequirement;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PropertiesCredentialMapping
extends AbstractDescribableImpl<PropertiesCredentialMapping>
implements Serializable {
    private final String propertyKey;
    private final String credentialsId;
    private static final DescriptorImpl DESCIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public PropertiesCredentialMapping(String propertyKey, String credentialsId) {
        this.propertyKey = propertyKey;
        this.credentialsId = credentialsId;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public Descriptor<PropertiesCredentialMapping> getDescriptor() {
        return DESCIPTOR;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PropertiesCredentialMapping> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String propertyKey) {
            Jenkins _context;
            Object object = _context = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getActiveInstance();
            if (_context == null || !_context.hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(propertyKey);
            }
            List<Object> domainRequirements = Collections.emptyList();
            if (StringUtils.isNotBlank((String)propertyKey)) {
                domainRequirements = Collections.singletonList(new PropertyKeyRequirement(propertyKey));
            }
            return new StandardUsernameListBoxModel().includeAs(context instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, context, StandardUsernameCredentials.class, domainRequirements).includeCurrentValue(propertyKey);
        }
    }
}

