/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.UnorderedStringSlicer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public abstract class ParametersStringSliceSpec<I>
extends UnorderedStringSlicer.UnorderedStringSlicerSpec<I> {
    static Logger LOG = Logger.getLogger("ParametersStringSlicing");
    static final String DELIM = "@@//@@";

    public abstract List<String> getParamNames();

    @Override
    public final boolean setValues(I item, List<String> set) {
        String value = set.get(0);
        String[] split = this.split(value);
        List<String> splitList = Arrays.asList(split);
        return this.doSetValues(item, splitList);
    }

    public abstract boolean doSetValues(I var1, List<String> var2);

    @Override
    public final List<String> getValues(I item) {
        List<String> values = this.doGetValues(item);
        String joinString = StringUtils.join(values, (String)DELIM);
        ArrayList<String> joined = new ArrayList<String>();
        joined.add(joinString);
        return joined;
    }

    @Override
    public final String getDefaultValueString() {
        String value = this.doGetDefaultValueString();
        int count = this.getParamNamesCount();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buf.append(DELIM);
            }
            buf.append(value);
        }
        return buf.toString();
    }

    public abstract String doGetDefaultValueString();

    public abstract List<String> doGetValues(I var1);

    public String getParamValue(String paramName, String configuredValue) {
        LOG.warning("paramName." + paramName);
        LOG.warning("configuredValue." + configuredValue);
        List<String> names = this.getParamNames();
        String[] values = this.split(configuredValue);
        for (int i = 0; i < names.size(); ++i) {
            if (!names.get(i).equals(paramName)) continue;
            if (i >= values.length) {
                LOG.warning("return blank");
                return "";
            }
            LOG.warning("return." + values[i]);
            return values[i];
        }
        return null;
    }

    private String[] split(String configuredValue) {
        return configuredValue.split(DELIM);
    }

    public int getParamNamesCount() {
        return this.getParamNames().size();
    }
}

