/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.buildtimeout;

import com.thoughtworks.xstream.XStreamException;
import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.plugins.build_timeout.BuildTimeoutWrapper;
import hudson.util.DescribableList;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

@Extension
public class BuildTimeoutSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(BuildTimeoutSlicer.class.getName());

    public BuildTimeoutSlicer() {
        super(new BuildTimeoutSliceSpec());
    }

    @Override
    public boolean isLoaded() {
        try {
            BuildTimeoutWrapper.class.toString();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static class BuildTimeoutSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String DISABLED = "(Disabled)";

        @Override
        public String getName() {
            return "Build Timeout";
        }

        @Override
        public String getUrl() {
            return "buildtimeout";
        }

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(BuildableItemWithBuildWrappers.class);
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            XStream2 xs = this.getXStream();
            BuildableItemWithBuildWrappers bi = (BuildableItemWithBuildWrappers)item;
            DescribableList wrappers = bi.getBuildWrappersList();
            ArrayList<String> values = new ArrayList<String>();
            BuildTimeoutWrapper wrapper = (BuildTimeoutWrapper)wrappers.get(BuildTimeoutWrapper.class);
            if (wrapper != null) {
                StringWriter sw = new StringWriter();
                xs.toXML((Object)wrapper, (Writer)sw);
                String value = sw.toString();
                values.add(value);
            }
            if (values.isEmpty()) {
                values.add(DISABLED);
            }
            return values;
        }

        private XStream2 getXStream() {
            XStream2 xs = new XStream2();
            this.addSimpleAlias(xs, "hudson.plugins.build_timeout.BuildTimeoutWrapper");
            this.addSimpleAlias(xs, "hudson.plugins.build_timeout.impl.AbsoluteTimeOutStrategy");
            this.addSimpleAlias(xs, "hudson.plugins.build_timeout.impl.DeadlineTimeOutStrategy");
            this.addSimpleAlias(xs, "hudson.plugins.build_timeout.impl.ElasticTimeOutStrategy");
            this.addSimpleAlias(xs, "hudson.plugins.build_timeout.impl.LikelyStuckTimeOutStrategy");
            this.addSimpleAlias(xs, "hudson.plugins.build_timeout.impl.NoActivityTimeOutStrategy");
            this.addSimpleAlias(xs, "hudson.plugins.build_timeout.operations.AbortOperation");
            this.addSimpleAlias(xs, "hudson.plugins.build_timeout.operations.BuildStepOperation");
            this.addSimpleAlias(xs, "hudson.plugins.build_timeout.operations.FailOperation");
            this.addSimpleAlias(xs, "hudson.plugins.build_timeout.operations.WriteDescriptionOperation");
            return xs;
        }

        private void addSimpleAlias(XStream2 xs, String className) {
            try {
                Class<?> type = Class.forName(className);
                String name = type.getSimpleName();
                xs.alias(name, type);
            }
            catch (ClassNotFoundException e) {
                LOGGER.info("Cannot load " + className);
            }
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, List<String> set) {
            LOGGER.info("BuildTimeoutSlicer.setValues for item " + item.getName());
            XStream2 xs = this.getXStream();
            BuildableItemWithBuildWrappers bi = (BuildableItemWithBuildWrappers)item;
            DescribableList wrappers = bi.getBuildWrappersList();
            boolean changed = false;
            BuildTimeoutWrapper wrapper = (BuildTimeoutWrapper)wrappers.get(BuildTimeoutWrapper.class);
            BuildTimeoutWrapper newWrapper = null;
            boolean delete = false;
            String line = set.iterator().next();
            if (DISABLED.equals(line) || StringUtils.isEmpty((String)line)) {
                delete = true;
            } else {
                try {
                    Object o = xs.fromXML(line);
                    if (o instanceof BuildTimeoutWrapper) {
                        newWrapper = (BuildTimeoutWrapper)o;
                        changed = true;
                    }
                }
                catch (XStreamException xse) {
                    LOGGER.warning("XStreamException parsing XML for BuildTimeoutSlicer: " + xse.getMessage());
                    changed = false;
                }
            }
            if (delete) {
                if (wrapper != null) {
                    wrappers.remove((Object)wrapper);
                    changed = true;
                }
            } else if (newWrapper != null && changed) {
                try {
                    wrappers.replace(newWrapper);
                }
                catch (IOException e) {
                    LOGGER.warning("IOException Thrown replacing wrapper value");
                    return false;
                }
            }
            return changed;
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getFullName();
        }

        @Override
        public String getDefaultValueString() {
            return DISABLED;
        }

        @Override
        public String getConfiguredValueDescription() {
            return "Build Timeout XML";
        }
    }
}

