/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.executeshell;

import configurationslicing.UnorderedStringSlicer;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;

public abstract class AbstractBuildCommandSlicer<B extends Builder>
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public AbstractBuildCommandSlicer(AbstractBuildCommandSliceSpec<B> spec) {
        super(spec);
    }

    public static abstract class AbstractBuildCommandSliceSpec<B extends Builder>
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        public static final String NOTHING = "(nothing)";

        @Override
        public String getDefaultValueString() {
            return NOTHING;
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getFullName();
        }

        @Override
        public boolean isIndexUsed(int count) {
            return count > 1;
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            ArrayList<String> content = new ArrayList<String>();
            DescribableList<Builder, Descriptor<Builder>> buildersList = AbstractBuildCommandSliceSpec.getBuildersList(item);
            List<B> builders = this.getConcreteBuildersList(buildersList);
            for (Builder builder : builders) {
                content.add(this.getCommand(builder));
            }
            if (content.isEmpty()) {
                content.add(NOTHING);
            }
            return content;
        }

        public abstract List<B> getConcreteBuildersList(DescribableList<Builder, Descriptor<Builder>> var1);

        public abstract String getCommand(B var1);

        public abstract B[] createBuilderArray(int var1);

        public abstract B createBuilder(String var1, List<B> var2, B var3);

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            ArrayList list = new ArrayList();
            List temp = Jenkins.getInstance().getAllItems(AbstractProject.class);
            for (AbstractProject p : temp) {
                if (!(p instanceof Project) && !(p instanceof MatrixProject)) continue;
                list.add(p);
            }
            return list;
        }

        public static DescribableList<Builder, Descriptor<Builder>> getBuildersList(AbstractProject<?, ?> item) {
            if (item instanceof Project) {
                return ((Project)item).getBuildersList();
            }
            if (item instanceof MatrixProject) {
                return ((MatrixProject)item).getBuildersList();
            }
            return null;
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, List<String> list) {
            int i;
            DescribableList<Builder, Descriptor<Builder>> buildersList = AbstractBuildCommandSliceSpec.getBuildersList(item);
            List<B> builders = this.getConcreteBuildersList(buildersList);
            int maxLen = Math.max(list.size(), builders.size());
            Builder[] oldBuilders = this.createBuilderArray(maxLen);
            Builder[] newBuilders = this.createBuilderArray(maxLen);
            for (i = 0; i < builders.size(); ++i) {
                oldBuilders[i] = (Builder)builders.get(i);
            }
            for (i = 0; i < list.size(); ++i) {
                String command = list.get(i);
                if (command.equals(NOTHING) || command.equals("")) continue;
                newBuilders[i] = oldBuilders[i] != null && this.getCommand(oldBuilders[i]).equals(command) ? oldBuilders[i] : this.createBuilder(command, builders, oldBuilders[i]);
            }
            for (i = 0; i < maxLen; ++i) {
                if (oldBuilders[i] == null || newBuilders[i] == null || oldBuilders[i] == newBuilders[i]) continue;
                AbstractBuildCommandSliceSpec.replaceBuilder(buildersList, oldBuilders[i], newBuilders[i]);
            }
            for (i = 0; i < maxLen; ++i) {
                if (oldBuilders[i] != null || newBuilders[i] == null) continue;
                buildersList.add((Object)newBuilders[i]);
            }
            for (i = 0; i < maxLen; ++i) {
                if (oldBuilders[i] == null || newBuilders[i] != null) continue;
                buildersList.remove((Object)oldBuilders[i]);
            }
            return true;
        }

        public static boolean replaceBuilder(DescribableList<Builder, Descriptor<Builder>> builders, Builder oldBuilder, Builder newBuilder) {
            ArrayList<Builder> newList = new ArrayList<Builder>(builders.toList());
            for (int i = 0; i < newList.size(); ++i) {
                Builder b = (Builder)newList.get(i);
                if (b != oldBuilder) continue;
                newList.set(i, newBuilder);
            }
            try {
                builders.replaceBy(newList);
                return true;
            }
            catch (IOException e) {
                System.err.println("IOException Thrown replacing builder list");
                return false;
            }
        }
    }
}

