/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.executeshell;

import configurationslicing.executeshell.AbstractBuildCommandSlicer;
import hudson.model.Descriptor;
import hudson.plugins.python.Python;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class ExecutePythonSlicer
extends AbstractBuildCommandSlicer<Python> {
    private static final Python.DescriptorImpl PYTHON_DESCRIPTOR = new Python.DescriptorImpl();

    public ExecutePythonSlicer() {
        super(new ExecutePythonSliceSpec());
    }

    @Override
    public void loadPluginDependencyClass() {
        Python.class.getClass();
    }

    public static class ExecutePythonSliceSpec
    extends AbstractBuildCommandSlicer.AbstractBuildCommandSliceSpec<Python> {
        @Override
        public String getName() {
            return "Execute Python script";
        }

        @Override
        public String getUrl() {
            return "executepythonslice";
        }

        @Override
        public Python createBuilder(String command, List<Python> existingBuilders, Python oldBuilder) {
            Python python = null;
            Constructor<?>[] cons = Python.class.getConstructors();
            if (cons.length > 0) {
                try {
                    if (!Modifier.isPublic(cons[0].getModifiers())) {
                        cons[0].setAccessible(true);
                    }
                    python = (Python)cons[0].newInstance(command);
                }
                catch (Exception e) {
                    python = null;
                }
            }
            if (python == null) {
                StaplerRequest req = null;
                JSONObject formData = new JSONObject();
                formData.put("python", (Object)command);
                try {
                    python = (Python)PYTHON_DESCRIPTOR.newInstance(req, formData);
                }
                catch (Descriptor.FormException e) {
                    python = null;
                }
            }
            return python;
        }

        public Python[] createBuilderArray(int len) {
            return new Python[len];
        }

        @Override
        public String getCommand(Python builder) {
            return builder.getCommand();
        }

        @Override
        public List<Python> getConcreteBuildersList(DescribableList<Builder, Descriptor<Builder>> buildersList) {
            return buildersList.getAll(Python.class);
        }
    }
}

