/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.label;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Label;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;

@Extension
public class LabelSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public LabelSlicer() {
        super(new LabelSliceSpec());
    }

    public static class LabelSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String ROAMING = "(Roaming)";

        @Override
        public String getDefaultValueString() {
            return ROAMING;
        }

        @Override
        public String getName() {
            return "Tied Label Slicer";
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "labelslicestring";
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            Label label = item.getAssignedLabel();
            String labelName = label == null ? ROAMING : label.getName();
            return Collections.singletonList(labelName);
        }

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(AbstractProject.class);
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, List<String> set) {
            if (set.isEmpty() || set.size() > 1) {
                return false;
            }
            Label label = null;
            String labelName = set.iterator().next();
            if (ROAMING.equals(labelName)) {
                label = null;
            } else {
                label = Jenkins.getInstance().getLabel(labelName);
                if (label == null) {
                    return false;
                }
            }
            try {
                item.setAssignedLabel(label);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

