/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.tools;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.model.AbstractProject;
import hudson.model.Project;
import hudson.tasks.Builder;
import hudson.tools.ToolInstallation;
import hudson.util.DescribableList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractToolSlicerSpec
extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(AbstractToolSlicerSpec.class.getName());

    @Override
    public abstract String getDefaultValueString();

    protected abstract Class<? extends Builder> getBuilderClass();

    protected abstract String getToolName(Builder var1);

    protected abstract ToolInstallation[] getToolInstallations();

    protected abstract Builder getNewBuilder(Builder var1, String var2);

    @Override
    public String getName(AbstractProject<?, ?> item) {
        return item.getFullName();
    }

    @Override
    public List<AbstractProject<?, ?>> getWorkDomain() {
        return TopLevelItemSelector.getAllTopLevelItems(AbstractProject.class);
    }

    @Override
    public List<String> getValues(AbstractProject<?, ?> item) {
        ArrayList<String> ret = new ArrayList<String>();
        if (!(item instanceof Project)) {
            return ret;
        }
        List builders = ((Project)item).getBuildersList().getAll(this.getBuilderClass());
        for (Builder builder : builders) {
            ret.add(this.getToolName(builder));
        }
        return ret;
    }

    @Override
    public boolean setValues(AbstractProject<?, ?> item, List<String> set) {
        if (!(item instanceof Project) || set.size() == 0) {
            return false;
        }
        DescribableList dl = ((Project)item).getBuildersList();
        List builders = dl.getAll(this.getBuilderClass());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(builders.toString() + " : " + set.toString());
        }
        String[] builderNames = new String[set.size()];
        set.toArray(builderNames);
        if (builders.size() != builderNames.length) {
            return false;
        }
        for (int i = 0; i < builderNames.length; ++i) {
            Builder oldBuilder = (Builder)builders.get(i);
            if (StringUtils.equals((String)this.getToolName(oldBuilder), (String)builderNames[i])) continue;
            if (null == this.getInstallations(builderNames[i])) {
                return false;
            }
            Builder newBuilder = this.getNewBuilder(oldBuilder, builderNames[i]);
            ArrayList<Builder> newBuilderList = new ArrayList<Builder>(dl.toList());
            newBuilderList.add(newBuilderList.indexOf(oldBuilder), newBuilder);
            newBuilderList.remove(oldBuilder);
            dl.clear();
            dl.addAll(newBuilderList);
        }
        return true;
    }

    protected ToolInstallation getInstallations(String installationName) {
        for (ToolInstallation ti : this.getToolInstallations()) {
            if (!StringUtils.equals((String)ti.getName(), (String)installationName)) continue;
            return ti;
        }
        return null;
    }
}

