/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsParameterValue;
import com.cloudbees.plugins.credentials.CredentialsResolver;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CredentialsProvider
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(CredentialsProvider.class.getName());
    public static final PermissionGroup GROUP = new PermissionGroup(CredentialsProvider.class, Messages._CredentialsProvider_PermissionGroupTitle());
    private static final PermissionScope[] SCOPES = new PermissionScope[]{PermissionScope.ITEM, PermissionScope.ITEM_GROUP, PermissionScope.JENKINS};
    public static final Permission CREATE = new Permission(GROUP, "Create", Messages._CredentialsProvider_CreatePermissionDescription(), Permission.CREATE, true, SCOPES);
    public static final Permission UPDATE = new Permission(GROUP, "Update", Messages._CredentialsProvider_UpdatePermissionDescription(), Permission.UPDATE, true, SCOPES);
    public static final Permission VIEW = new Permission(GROUP, "View", Messages._CredentialsProvider_ViewPermissionDescription(), Permission.READ, true, SCOPES);
    public static final Permission DELETE = new Permission(GROUP, "Delete", Messages._CredentialsProvider_DeletePermissionDescription(), Permission.DELETE, true, SCOPES);
    public static final Permission MANAGE_DOMAINS = new Permission(GROUP, "ManageDomains", Messages._CredentialsProvider_ManageDomainsPermissionDescription(), Permission.CONFIGURE, true, SCOPES);
    public static final Permission USE_OWN = new Permission(GROUP, "UseOwn", Messages._CredentialsProvider_UseOwnPermissionDescription(), Boolean.getBoolean("com.cloudbees.plugins.credentials.UseOwnPermission") ? Jenkins.ADMINISTER : Job.BUILD, Boolean.getBoolean("com.cloudbees.plugins.credentials.UseOwnPermission"), new PermissionScope[]{PermissionScope.ITEM});
    public static final Permission USE_ITEM = new Permission(GROUP, "UseItem", Messages._CredentialsProvider_UseItemPermissionDescription(), Job.CONFIGURE, Boolean.getBoolean("com.cloudbees.plugins.credentials.UseItemPermission"), new PermissionScope[]{PermissionScope.ITEM});

    public static DescriptorExtensionList<Credentials, CredentialsDescriptor> allCredentialsDescriptors() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has not been started, or was already shut down");
        }
        return jenkins.getDescriptorList(Credentials.class);
    }

    public Set<CredentialsScope> getScopes(ModelObject object) {
        return null;
    }

    @CheckForNull
    public CredentialsStore getStore(@CheckForNull ModelObject object) {
        return null;
    }

    @NonNull
    public abstract <C extends Credentials> List<C> getCredentials(@NonNull Class<C> var1, @Nullable ItemGroup var2, @Nullable Authentication var3);

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentials(type, itemGroup, authentication);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication) {
        item.getClass();
        return this.getCredentials(type, item.getParent(), authentication);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentials(type, item.getParent(), authentication, domainRequirements);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type) {
        return CredentialsProvider.lookupCredentials(type, (Item)null, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, (ItemGroup)Jenkins.getInstance(), authentication);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item) {
        return item == null ? CredentialsProvider.lookupCredentials(type, (ItemGroup)Jenkins.getInstance(), ACL.SYSTEM) : CredentialsProvider.lookupCredentials(type, item, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, authentication, Collections.<DomainRequirement>emptyList());
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, item, authentication, Collections.<DomainRequirement>emptyList());
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, authentication, Arrays.asList(domainRequirements));
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements) {
        type.getClass();
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has not been started, or was already shut down");
        }
        itemGroup = itemGroup == null ? jenkins : itemGroup;
        authentication = authentication == null ? ACL.SYSTEM : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null) {
            LOGGER.log(Level.FINE, "Resolving legacy credentials of type {0} with resolver {1}", new Object[]{type, resolver});
            List<Credentials> originals = CredentialsProvider.lookupCredentials(resolver.getFromClass(), itemGroup, authentication, domainRequirements);
            LOGGER.log(Level.FINE, "Original credentials for resolving: {0}", originals);
            return resolver.resolve(originals);
        }
        ArrayList<C> result = new ArrayList<C>();
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            try {
                result.addAll(provider.getCredentials(type, itemGroup, authentication, domainRequirements));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + provider + " likely due to missing optional dependency", e);
            }
        }
        return result;
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.lookupCredentials(type, item, authentication, Arrays.asList(domainRequirements));
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements) {
        type.getClass();
        if (item == null) {
            return CredentialsProvider.lookupCredentials(type, (ItemGroup)Jenkins.getInstance(), authentication);
        }
        authentication = authentication == null ? ACL.SYSTEM : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null) {
            LOGGER.log(Level.FINE, "Resolving legacy credentials of type {0} with resolver {1}", new Object[]{type, resolver});
            List<Credentials> originals = CredentialsProvider.lookupCredentials(resolver.getFromClass(), item, authentication, domainRequirements);
            LOGGER.log(Level.FINE, "Original credentials for resolving: {0}", originals);
            return resolver.resolve(originals);
        }
        ArrayList<C> result = new ArrayList<C>();
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            try {
                result.addAll(provider.getCredentials(type, item, authentication, domainRequirements));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + provider + " likely due to missing optional dependency", e);
            }
        }
        return result;
    }

    @CheckForNull
    public static Set<CredentialsScope> lookupScopes(ModelObject object) {
        if (object instanceof CredentialsStoreAction.CredentialsWrapper) {
            object = ((CredentialsStoreAction.CredentialsWrapper)object).getStore().getContext();
        }
        if (object instanceof CredentialsStoreAction.DomainWrapper) {
            object = ((CredentialsStoreAction.DomainWrapper)object).getStore().getContext();
        }
        LinkedHashSet<CredentialsScope> result = null;
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            try {
                Set<CredentialsScope> scopes = provider.getScopes(object);
                if (scopes == null) continue;
                if (result == null) {
                    result = new LinkedHashSet<CredentialsScope>();
                }
                result.addAll(scopes);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return result;
    }

    public static Iterable<CredentialsStore> lookupStores(final ModelObject object) {
        final ExtensionList<CredentialsProvider> providers = CredentialsProvider.all();
        return new Iterable<CredentialsStore>(){

            @Override
            public Iterator<CredentialsStore> iterator() {
                return new Iterator<CredentialsStore>(){
                    private ModelObject current;
                    private Iterator<CredentialsProvider> iterator;
                    private CredentialsStore next;
                    {
                        this.current = object;
                        this.iterator = providers.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        while (this.current != null) {
                            while (this.iterator.hasNext()) {
                                CredentialsProvider p = this.iterator.next();
                                this.next = p.getStore(this.current);
                                if (this.next == null) continue;
                                return true;
                            }
                            if (this.current instanceof Item) {
                                this.current = ((Item)this.current).getParent();
                                this.iterator = providers.iterator();
                                continue;
                            }
                            if (this.current instanceof User) {
                                this.current = null;
                                continue;
                            }
                            if (!(this.current instanceof Jenkins)) continue;
                            this.current = null;
                        }
                        return false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public CredentialsStore next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        try {
                            CredentialsStore credentialsStore = this.next;
                            return credentialsStore;
                        }
                        finally {
                            this.next = null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <C extends Credentials> C snapshot(C credential) {
        return (C)CredentialsProvider.snapshot(Credentials.class, credential);
    }

    public static <C extends Credentials> C snapshot(Class<C> clazz, C credential) {
        Class bestType = null;
        CredentialsSnapshotTaker bestTaker = null;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            for (CredentialsSnapshotTaker taker : jenkins.getExtensionList(CredentialsSnapshotTaker.class)) {
                if (!clazz.isAssignableFrom(taker.type()) || !taker.type().isInstance(credential) || bestTaker != null && !bestType.isAssignableFrom(taker.type())) continue;
                bestTaker = taker;
                bestType = taker.type();
            }
        }
        if (bestTaker == null) {
            return credential;
        }
        return (C)((Credentials)clazz.cast(bestTaker.snapshot(credential)));
    }

    @NonNull
    static Authentication getDefaultAuthenticationOf(Item item) {
        if (item instanceof Queue.Task) {
            return Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item));
        }
        return ACL.SYSTEM;
    }

    @CheckForNull
    public static <C extends IdCredentials> C findCredentialById(@NonNull String id, @NonNull Class<C> type, @NonNull Run<?, ?> run, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.findCredentialById(id, type, run, Arrays.asList(domainRequirements));
    }

    @CheckForNull
    public static <C extends IdCredentials> C findCredentialById(@NonNull String id, @NonNull Class<C> type, @NonNull Run<?, ?> run, @Nullable List<DomainRequirement> domainRequirements) {
        ParameterValue parameter;
        ParametersAction action;
        id.getClass();
        type.getClass();
        run.getClass();
        id = id.trim();
        boolean isParameter = false;
        boolean isDefaultValue = false;
        if (id.startsWith("${") && id.endsWith("}") && (action = (ParametersAction)run.getAction(ParametersAction.class)) != null && (parameter = action.getParameter(id.substring(2, id.length() - 1))) instanceof CredentialsParameterValue) {
            isParameter = true;
            isDefaultValue = ((CredentialsParameterValue)parameter).isDefaultValue();
            id = ((CredentialsParameterValue)parameter).getValue();
        }
        if (!isParameter || isDefaultValue) {
            Authentication runAuth = CredentialsProvider.getDefaultAuthenticationOf((Item)run.getParent());
            ArrayList<C> candidates = new ArrayList<C>();
            candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), runAuth, domainRequirements));
            if (runAuth != ACL.SYSTEM && run.getACL().hasPermission(runAuth, USE_ITEM)) {
                candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), ACL.SYSTEM, domainRequirements));
            }
            return (C)((IdCredentials)CredentialsMatchers.firstOrNull(candidates, CredentialsMatchers.withId(id)));
        }
        Map.Entry<User, Run<?, ?>> triggeredBy = CredentialsProvider.triggeredBy(run);
        Authentication a = triggeredBy == null ? Jenkins.ANONYMOUS : triggeredBy.getKey().impersonate();
        ArrayList<C> candidates = new ArrayList<C>();
        if (triggeredBy != null && run == triggeredBy.getValue() && run.getACL().hasPermission(a, USE_OWN)) {
            candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), a, domainRequirements));
        }
        if (run.getACL().hasPermission(a, USE_ITEM)) {
            Authentication runAuth = CredentialsProvider.getDefaultAuthenticationOf((Item)run.getParent());
            candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), runAuth, domainRequirements));
            if (runAuth != ACL.SYSTEM && run.getACL().hasPermission(runAuth, USE_ITEM)) {
                candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), ACL.SYSTEM, domainRequirements));
            }
        }
        return (C)((IdCredentials)CredentialsMatchers.firstOrNull(candidates, CredentialsMatchers.withId(id)));
    }

    private static Map.Entry<User, Run<?, ?>> triggeredBy(Run<?, ?> run) {
        Cause.UserIdCause cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
        if (cause != null) {
            User u = User.get((String)cause.getUserId(), (boolean)false, Collections.emptyMap());
            return u == null ? null : new AbstractMap.SimpleImmutableEntry<User, Run>(u, run);
        }
        Cause.UpstreamCause c = (Cause.UpstreamCause)run.getCause(Cause.UpstreamCause.class);
        Run run2 = run = c != null ? c.getUpstreamRun() : null;
        while (run != null) {
            cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
            if (cause != null) {
                User u = User.get((String)cause.getUserId(), (boolean)false, Collections.emptyMap());
                return u == null ? null : new AbstractMap.SimpleImmutableEntry<User, Run>(u, run);
            }
            c = (Cause.UpstreamCause)run.getCause(Cause.UpstreamCause.class);
            run = c != null ? c.getUpstreamRun() : null;
        }
        return null;
    }

    public static ExtensionList<CredentialsProvider> all() {
        Jenkins jenkins = Jenkins.getInstance();
        return jenkins == null ? ExtensionList.create((Jenkins)null, CredentialsProvider.class) : jenkins.getExtensionList(CredentialsProvider.class);
    }
}

