/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.common;

import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

@NameWith(value=NameProvider.class, priority=8)
public interface StandardCertificateCredentials
extends StandardCredentials,
CertificateCredentials {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameProvider
    extends CredentialsNameProvider<StandardCertificateCredentials> {
        @Override
        @NonNull
        public String getName(@NonNull StandardCertificateCredentials c) {
            String description = Util.fixEmptyAndTrim((String)c.getDescription());
            String subjectDN = NameProvider.getSubjectDN(c.getKeyStore());
            return (subjectDN == null ? c.getDescriptor().getDisplayName() : subjectDN) + (description != null ? " (" + description + ")" : "");
        }

        @CheckForNull
        public static String getSubjectDN(@NonNull KeyStore keyStore) {
            keyStore.getClass();
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    Certificate certificate;
                    Certificate[] certificateChain;
                    String alias = enumeration.nextElement();
                    if (!keyStore.isKeyEntry(alias) || (certificateChain = keyStore.getCertificateChain(alias)) == null || certificateChain.length <= 0 || !((certificate = certificateChain[0]) instanceof X509Certificate)) continue;
                    X509Certificate x509 = (X509Certificate)certificate;
                    return x509.getSubjectDN().getName();
                }
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            return null;
        }
    }
}

