/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.model.queue.WorkUnit;
import hudson.security.ACL;
import hudson.util.VariableResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class CredentialsParameterValue
extends ParameterValue {
    private final String value;
    private final boolean isDefaultValue;

    @DataBoundConstructor
    public CredentialsParameterValue(String name, String value, String description) {
        this(name, value, description, false);
    }

    public CredentialsParameterValue(String name, String value, String description, boolean isDefaultValue) {
        super(name, description);
        this.value = value;
        this.isDefaultValue = isDefaultValue;
    }

    public String getValue() {
        return this.value;
    }

    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.name, this.value);
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                return CredentialsParameterValue.this.name.equals(name) ? CredentialsParameterValue.this.value : null;
            }
        };
    }

    public boolean isSensitive() {
        return true;
    }

    public <C extends IdCredentials> C lookupCredentials(@NonNull Class<C> type, @NonNull Run run, DomainRequirement ... domainRequirements) {
        return this.lookupCredentials(type, run, Arrays.asList(domainRequirements));
    }

    public <C extends IdCredentials> C lookupCredentials(@NonNull Class<C> type, @NonNull Run run, List<DomainRequirement> domainRequirements) {
        WorkUnit workUnit;
        Authentication authentication = Jenkins.getAuthentication();
        Executor executor = run.getExecutor();
        if (executor != null && (workUnit = executor.getCurrentWorkUnit()) != null) {
            authentication = workUnit.context.item.authenticate();
        }
        ArrayList<C> candidates = new ArrayList<C>();
        boolean isSystem = ACL.SYSTEM.equals(authentication);
        if (!isSystem && run.getParent().getACL().hasPermission(CredentialsProvider.USE_OWN)) {
            candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), authentication, domainRequirements));
        }
        if (run.getParent().getACL().hasPermission(CredentialsProvider.USE_ITEM) || isSystem || this.isDefaultValue) {
            candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), ACL.SYSTEM, domainRequirements));
        }
        return (C)((IdCredentials)CredentialsMatchers.firstOrNull(candidates, CredentialsMatchers.withId(this.value)));
    }

    public String describe() {
        if (StringUtils.isBlank((String)this.value)) {
            return "";
        }
        Run run = (Run)Stapler.getCurrentRequest().findAncestorObject(Run.class);
        if (run == null) {
            throw new IllegalStateException("Should only be called from value.jelly");
        }
        StandardCredentials c = CredentialsMatchers.firstOrNull(CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)run.getParent(), ACL.SYSTEM, Collections.<DomainRequirement>emptyList()), CredentialsMatchers.withId(this.value));
        if (c != null) {
            return CredentialsNameProvider.name(c);
        }
        c = CredentialsMatchers.firstOrNull(CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)run.getParent(), Jenkins.getAuthentication(), Collections.<DomainRequirement>emptyList()), CredentialsMatchers.withId(this.value));
        if (c != null) {
            return CredentialsNameProvider.name(c);
        }
        return Messages.CredentialsParameterValue_NotAvailableToCurrentUser();
    }

    public boolean isDefaultValue() {
        return this.isDefaultValue;
    }
}

