/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.FormApply;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class CredentialsSelectHelper
extends Descriptor<CredentialsSelectHelper>
implements Describable<CredentialsSelectHelper> {
    public static final Permission CREATE = CredentialsProvider.CREATE;

    public CredentialsSelectHelper() {
        super(CredentialsSelectHelper.class);
    }

    public CredentialsSelectHelper getDescriptor() {
        return this;
    }

    public String getDisplayName() {
        return Messages.CredentialsSelectHelper_DisplayName();
    }

    @Restricted(value={NoExternalUse.class})
    public List<StoreItem> getStoreItems(boolean includeUser) {
        ArrayList<StoreItem> result = new ArrayList<StoreItem>();
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null) {
            ModelObject context = (ModelObject)request.findAncestorObject(ModelObject.class);
            if (context != null) {
                for (CredentialsStore store : CredentialsProvider.lookupStores(context)) {
                    result.add(new StoreItem(store));
                }
            }
            if (includeUser) {
                boolean hasPermission = false;
                ModelObject current = context;
                while (current != null) {
                    if (current instanceof AccessControlled) {
                        hasPermission = ((AccessControlled)current).hasPermission(CredentialsProvider.USE_OWN);
                        break;
                    }
                    if (current instanceof Item) {
                        current = ((Item)current).getParent();
                        continue;
                    }
                    if (current instanceof User) {
                        current = null;
                        continue;
                    }
                    if (!(current instanceof Jenkins)) continue;
                    current = null;
                }
                if (hasPermission) {
                    for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)User.current())) {
                        result.add(new StoreItem(store));
                    }
                }
            }
        }
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    public WrappedContextResolver getResolver(String className) {
        for (ContextResolver r : ExtensionList.lookup(ContextResolver.class)) {
            if (!r.getClass().getName().equals(className)) continue;
            return new WrappedContextResolver(r);
        }
        return null;
    }

    @Extension
    public static class UserContextResolver
    extends ContextResolver {
        @Override
        public String getToken(ModelObject context) {
            return context instanceof User ? ((User)context).getId() : null;
        }

        @Override
        public ModelObject getContext(String token) {
            try {
                Method getById = User.class.getMethod("getById", String.class, Boolean.TYPE);
                return (ModelObject)getById.invoke(null, token, false);
            }
            catch (NoSuchMethodException e) {
                return User.get((String)token, (boolean)false, Collections.emptyMap());
            }
            catch (InvocationTargetException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
    }

    @Extension
    public static class ItemContextResolver
    extends ContextResolver {
        @Override
        public String getToken(ModelObject context) {
            return context instanceof Item ? ((Item)context).getFullName() : null;
        }

        @Override
        public ModelObject getContext(String token) {
            return Jenkins.getActiveInstance().getItemByFullName(token);
        }
    }

    @Extension(ordinal=1000.0)
    public static class SystemContextResolver
    extends ContextResolver {
        @Override
        public String getToken(ModelObject context) {
            return context instanceof Jenkins ? "jenkins" : null;
        }

        @Override
        public ModelObject getContext(String token) {
            return "jenkins".equals(token) ? Jenkins.getActiveInstance() : null;
        }
    }

    public static abstract class ContextResolver
    implements ExtensionPoint {
        @CheckForNull
        public abstract String getToken(ModelObject var1);

        @CheckForNull
        public abstract ModelObject getContext(String var1);
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WrappedCredentialsStore
    implements IconSpec,
    ModelObject {
        @NonNull
        private final ContextResolver resolver;
        @NonNull
        private final CredentialsProvider provider;
        @NonNull
        private final String token;
        private final CredentialsStore store;

        public WrappedCredentialsStore(ContextResolver resolver, CredentialsProvider provider, String token, CredentialsStore store) {
            this.store = store;
            this.resolver = resolver;
            this.provider = provider;
            this.token = token;
        }

        @RequirePOST
        public void doAddCredentials(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            if (!this.store.isDomainsModifiable()) {
                HttpResponses.status((int)400).generateResponse(req, rsp, null);
                FormApply.applyResponse((String)"window.alert('Domain is read-only')").generateResponse(req, rsp, null);
            }
            this.store.checkPermission(CredentialsStoreAction.CREATE);
            JSONObject data = req.getSubmittedForm();
            String domainName = data.getString("domain");
            CredentialsStoreAction.DomainWrapper wrapper = this.getWrappers().get(domainName);
            if (!this.store.getDomains().contains(wrapper.getDomain())) {
                HttpResponses.status((int)400).generateResponse(req, rsp, null);
                FormApply.applyResponse((String)"window.alert('Store does not have selected domain')").generateResponse(req, rsp, null);
            }
            this.store.checkPermission(CredentialsStoreAction.CREATE);
            Credentials credentials = (Credentials)req.bindJSON(Credentials.class, data.getJSONObject("credentials"));
            this.store.addCredentials(wrapper.getDomain(), credentials);
            FormApply.applyResponse((String)"window.credentials.refreshAll();").generateResponse(req, rsp, null);
        }

        public CredentialsStoreAction.DomainWrapper getWrapper() {
            Collection<CredentialsStoreAction.DomainWrapper> values = this.getWrappers().values();
            return values.isEmpty() ? null : values.iterator().next();
        }

        public String getIconClassName() {
            return this.store.getProvider().getIconClassName();
        }

        public String getDisplayName() {
            return this.store.getContextDisplayName();
        }

        public String getDescription() {
            return this.store.getProvider().getDisplayName();
        }

        public String getUrl() {
            return String.format("%sdescriptor/%s/resolver/%s/provider/%s/context/%s", Jenkins.getActiveInstance().getRootUrlFromRequest(), CredentialsSelectHelper.class.getName(), Util.rawEncode((String)this.resolver.getClass().getName()), Util.rawEncode((String)((Object)((Object)this.provider)).getClass().getName()), Util.rawEncode((String)this.token));
        }

        public List<CredentialsDescriptor> getCredentialsDescriptors() {
            return this.store.getCredentialsDescriptors();
        }

        public Map<String, CredentialsStoreAction.DomainWrapper> getWrappers() {
            CredentialsStoreAction action = this.store.getStoreAction();
            return action != null ? action.getDomains() : new CredentialsStoreAction(){

                @Override
                @NonNull
                public CredentialsStore getStore() {
                    return WrappedCredentialsStore.this.store;
                }
            }.getDomains();
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WrappedContextResolverCredentialsProvider {
        @NonNull
        private final ContextResolver resolver;
        @NonNull
        private final CredentialsProvider provider;

        public WrappedContextResolverCredentialsProvider(@NonNull ContextResolver resolver, @NonNull CredentialsProvider provider) {
            this.resolver = resolver;
            this.provider = provider;
        }

        public WrappedCredentialsStore getContext(String token) {
            CredentialsStore store;
            ModelObject context = this.resolver.getContext(token);
            if (context != null && (store = this.provider.getStore(context)) != null) {
                return new WrappedCredentialsStore(this.resolver, this.provider, token, store);
            }
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WrappedContextResolver {
        @NonNull
        private final ContextResolver resolver;

        public WrappedContextResolver(@NonNull ContextResolver resolver) {
            this.resolver = resolver;
        }

        @CheckForNull
        public WrappedContextResolverCredentialsProvider getProvider(String className) {
            for (CredentialsProvider p : CredentialsProvider.enabled()) {
                if (!((Object)((Object)p)).getClass().getName().equals(className)) continue;
                return new WrappedContextResolverCredentialsProvider(this.resolver, p);
            }
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class StoreItem
    implements IconSpec,
    ModelObject {
        private final CredentialsStore store;
        private final String url;

        public StoreItem(CredentialsStore store) {
            this.store = store;
            String provider = ((Object)((Object)store.getProvider())).getClass().getName();
            String resolver = null;
            String token = null;
            ModelObject storeContext = store.getContext();
            for (ContextResolver r : ExtensionList.lookup(ContextResolver.class)) {
                String t = r.getToken(storeContext);
                if (t == null) continue;
                resolver = r.getClass().getName();
                token = t;
                break;
            }
            this.url = token == null ? null : String.format("%sdescriptor/%s/resolver/%s/provider/%s/context/%s", Jenkins.getActiveInstance().getRootUrlFromRequest(), CredentialsSelectHelper.class.getName(), Util.rawEncode((String)resolver), Util.rawEncode((String)provider), Util.rawEncode((String)token));
        }

        public String getIconClassName() {
            return this.store.getProvider().getIconClassName();
        }

        public boolean isEnabled() {
            return this.url != null && this.store.hasPermission(Permission.CREATE) && !this.store.getCredentialsDescriptors().isEmpty();
        }

        public String getDisplayName() {
            return this.store.getContextDisplayName();
        }

        public String getDescription() {
            return this.store.getProvider().getDisplayName();
        }

        public String getUrl() {
            return this.url;
        }
    }
}

