/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.common;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.Iterator;

public abstract class AbstractIdCredentialsListBoxModel<T extends AbstractIdCredentialsListBoxModel<T, C>, C extends IdCredentials>
extends ListBoxModel {
    @NonNull
    protected abstract String describe(@NonNull C var1);

    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> with(@CheckForNull C u) {
        if (u != null) {
            this.add(this.describe(u), u.getId());
        }
        return this;
    }

    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withEmptySelection() {
        this.add(Messages.AbstractIdCredentialsListBoxModel_EmptySelection(), "");
        return this;
    }

    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withAll(C ... credentials) {
        return this.withMatching(CredentialsMatchers.always(), (Iterable<? extends C>)Arrays.asList(credentials));
    }

    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withAll(@NonNull Iterable<? extends C> credentials) {
        return this.withMatching(CredentialsMatchers.always(), credentials.iterator());
    }

    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withAll(@NonNull Iterator<? extends C> credentials) {
        return this.withMatching(CredentialsMatchers.always(), credentials);
    }

    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withMatching(@NonNull CredentialsMatcher matcher, C ... credentials) {
        return this.withMatching(matcher, (Iterable<? extends C>)Arrays.asList(credentials));
    }

    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withMatching(@NonNull CredentialsMatcher matcher, @NonNull Iterable<? extends C> credentials) {
        return this.withMatching(matcher, credentials.iterator());
    }

    @NonNull
    public AbstractIdCredentialsListBoxModel<T, C> withMatching(@NonNull CredentialsMatcher matcher, @NonNull Iterator<? extends C> credentials) {
        while (credentials.hasNext()) {
            IdCredentials c = (IdCredentials)credentials.next();
            if (!matcher.matches(c)) continue;
            this.with(c);
        }
        return this;
    }
}

