/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.matchers;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsScope;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class ScopeMatcher
implements CredentialsMatcher {
    @NonNull
    private final Set<CredentialsScope> scopes;

    public ScopeMatcher(@NonNull CredentialsScope scope) {
        scope.getClass();
        this.scopes = Collections.singleton(scope);
    }

    public ScopeMatcher(CredentialsScope ... scopes) {
        this.scopes = EnumSet.copyOf(Arrays.asList(scopes));
    }

    public ScopeMatcher(@NonNull Collection<CredentialsScope> scopes) {
        this.scopes = EnumSet.copyOf(scopes);
    }

    @Override
    public boolean matches(@NonNull Credentials item) {
        return this.scopes.contains(item.getScope());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ScopeMatcher{");
        sb.append("scopes=").append(this.scopes);
        sb.append('}');
        return sb.toString();
    }
}

