/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Node;
import hudson.model.Run;
import org.jenkinsci.plugins.docker.commons.fingerprint.ContainerRecord;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerFingerprints;
import org.jenkinsci.plugins.docker.workflow.ImageAction;
import org.jenkinsci.plugins.docker.workflow.client.DockerClient;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RunFingerprintStep
extends AbstractStepImpl {
    private final String containerId;
    private String toolName;

    @DataBoundConstructor
    public RunFingerprintStep(String containerId) {
        this.containerId = containerId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getToolName() {
        return this.toolName;
    }

    @DataBoundSetter
    public void setToolName(String toolName) {
        this.toolName = Util.fixEmpty((String)toolName);
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "dockerFingerprintRun";
        }

        public String getDisplayName() {
            return "Record trace of a Docker image run in a container";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient RunFingerprintStep step;
        @StepContextParameter
        private transient Run run;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient EnvVars env;
        @StepContextParameter
        private transient Node node;

        protected Void run() throws Exception {
            DockerClient client = new DockerClient(this.launcher, this.node, this.step.toolName);
            DockerFingerprints.addRunFacet((ContainerRecord)client.getContainerRecord(this.env, this.step.containerId), (Run)this.run);
            String image = client.inspect(this.env, this.step.containerId, ".Config.Image");
            if (image != null) {
                ImageAction.add(image, this.run);
            }
            return null;
        }
    }
}

