package hudson.plugins.emailext.plugins.trigger;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.recipients.ListRecipientProvider;
import java.util.List;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.kohsuke.stapler.DataBoundConstructor;

public class ScriptTrigger extends AbstractScriptTrigger {

    public static final String TRIGGER_NAME = "Script - After Build";

    @DataBoundConstructor
    public ScriptTrigger(
            List<RecipientProvider> recipientProviders,
            String recipientList,
            String replyTo,
            String subject,
            String body,
            String attachmentsPattern,
            int attachBuildLog,
            String contentType,
            SecureGroovyScript secureTriggerScript) {
        super(
                recipientProviders,
                recipientList,
                replyTo,
                subject,
                body,
                attachmentsPattern,
                attachBuildLog,
                contentType,
                secureTriggerScript);
    }

    @Deprecated
    public ScriptTrigger(
            List<RecipientProvider> recipientProviders,
            String recipientList,
            String replyTo,
            String subject,
            String body,
            String attachmentsPattern,
            int attachBuildLog,
            String contentType,
            String triggerScript) {
        super(
                recipientProviders,
                recipientList,
                replyTo,
                subject,
                body,
                attachmentsPattern,
                attachBuildLog,
                contentType,
                triggerScript);
    }

    @Deprecated
    public ScriptTrigger(
            boolean sendToList,
            boolean sendToDevs,
            boolean sendToRequester,
            boolean sendToCulprits,
            String recipientList,
            String replyTo,
            String subject,
            String body,
            String attachmentsPattern,
            int attachBuildLog,
            String contentType,
            String triggerScript) {
        super(
                sendToList,
                sendToDevs,
                sendToRequester,
                sendToCulprits,
                recipientList,
                replyTo,
                subject,
                body,
                attachmentsPattern,
                attachBuildLog,
                contentType,
                triggerScript);
    }

    @Override
    public boolean isPreBuild() {
        return false;
    }

    @Extension
    public static class DescriptorImpl extends EmailTriggerDescriptor {

        public DescriptorImpl() {
            addDefaultRecipientProvider(new ListRecipientProvider());
        }

        @NonNull
        @Override
        public String getDisplayName() {
            return TRIGGER_NAME;
        }

        @Override
        public boolean isWatchable() {
            return false;
        }

        @Override
        public EmailTrigger createDefault() {
            return new ScriptTrigger(
                    defaultRecipientProviders,
                    "",
                    "$PROJECT_DEFAULT_REPLYTO",
                    "$PROJECT_DEFAULT_SUBJECT",
                    "$PROJECT_DEFAULT_CONTENT",
                    "",
                    0,
                    "project",
                    new SecureGroovyScript("", false, null));
        }
    }
}
