// CHECKSTYLE:OFF

package hudson.plugins.emailext.plugins.trigger;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * An email will be sent if the build status is "Aborted".
     * 
     */
    public static String AbortedTrigger_HelpText() {
        return holder.format("AbortedTrigger.HelpText");
    }

    /**
     * An email will be sent if the build status is "Aborted".
     * 
     */
    public static Localizable _AbortedTrigger_HelpText() {
        return new Localizable(holder, "AbortedTrigger.HelpText");
    }

    /**
     * An email will be sent any time the build goes from failing, to unstable. This basically means thatall the builds steps were successful, but there are still tests failing.
     * 
     */
    public static String BuildingTrigger_HelpText() {
        return holder.format("BuildingTrigger.HelpText");
    }

    /**
     * An email will be sent any time the build goes from failing, to unstable. This basically means thatall the builds steps were successful, but there are still tests failing.
     * 
     */
    public static Localizable _BuildingTrigger_HelpText() {
        return new Localizable(holder, "BuildingTrigger.HelpText");
    }

    /**
     * An email will be sent when the build status changes from "Failure" or "Unstable" to "Successful".
     * 
     */
    public static String FixedTrigger_HelpText() {
        return holder.format("FixedTrigger.HelpText");
    }

    /**
     * An email will be sent when the build status changes from "Failure" or "Unstable" to "Successful".
     * 
     */
    public static Localizable _FixedTrigger_HelpText() {
        return new Localizable(holder, "FixedTrigger.HelpText");
    }

    /**
     * An email will be sent any time the build fails.  If the "Still Failing" trigger is configured,and the previous build status was "Failure", then the "Still Failing" trigger will send an email instead.
     * 
     */
    public static String FailureTrigger_HelpText() {
        return holder.format("FailureTrigger.HelpText");
    }

    /**
     * An email will be sent any time the build fails.  If the "Still Failing" trigger is configured,and the previous build status was "Failure", then the "Still Failing" trigger will send an email instead.
     * 
     */
    public static Localizable _FailureTrigger_HelpText() {
        return new Localizable(holder, "FailureTrigger.HelpText");
    }

    /**
     * An email will be sent any time the build is unstable.If the "Still Unstable" trigger is configured, and the previous build status was "Unstable",then the "Still Unstable" trigger will send an email instead.
     * 
     */
    public static String UnstableTrigger_HelpText() {
        return holder.format("UnstableTrigger.HelpText");
    }

    /**
     * An email will be sent any time the build is unstable.If the "Still Unstable" trigger is configured, and the previous build status was "Unstable",then the "Still Unstable" trigger will send an email instead.
     * 
     */
    public static Localizable _UnstableTrigger_HelpText() {
        return new Localizable(holder, "UnstableTrigger.HelpText");
    }

    /**
     * An email will be sent if the build status is "Unstable" for two or more builds in a row.
     * 
     */
    public static String StillUnstableTrigger_HelpText() {
        return holder.format("StillUnstableTrigger.HelpText");
    }

    /**
     * An email will be sent if the build status is "Unstable" for two or more builds in a row.
     * 
     */
    public static Localizable _StillUnstableTrigger_HelpText() {
        return new Localizable(holder, "StillUnstableTrigger.HelpText");
    }

    /**
     * An email will be sent any time there is an improvement. A build is considered to have improved wheneverit has fewer failures than the previous build. If the current failure count went to 0 (no more failures)this trigger will NOT send an email.
     * 
     */
    public static String ImprovementTrigger_HelpText() {
        return holder.format("ImprovementTrigger.HelpText");
    }

    /**
     * An email will be sent any time there is an improvement. A build is considered to have improved wheneverit has fewer failures than the previous build. If the current failure count went to 0 (no more failures)this trigger will NOT send an email.
     * 
     */
    public static Localizable _ImprovementTrigger_HelpText() {
        return new Localizable(holder, "ImprovementTrigger.HelpText");
    }

    /**
     * An email will be sent if the build status is "Not Built".
     * 
     */
    public static String NotBuiltTrigger_HelpText() {
        return holder.format("NotBuiltTrigger.HelpText");
    }

    /**
     * An email will be sent if the build status is "Not Built".
     * 
     */
    public static Localizable _NotBuiltTrigger_HelpText() {
        return new Localizable(holder, "NotBuiltTrigger.HelpText");
    }

    /**
     * Allows the user to define a script which must have the last line resolve to a true or false which willindicate whether the trigger should cause an email to be sent BEFORE build or not.
     * 
     */
    public static String PreBuildScriptTrigger_HelpText() {
        return holder.format("PreBuildScriptTrigger.HelpText");
    }

    /**
     * Allows the user to define a script which must have the last line resolve to a true or false which willindicate whether the trigger should cause an email to be sent BEFORE build or not.
     * 
     */
    public static Localizable _PreBuildScriptTrigger_HelpText() {
        return new Localizable(holder, "PreBuildScriptTrigger.HelpText");
    }

    /**
     * An email will be sent any time there is a regression. A build is considered to regress whenever it hasmore failures than the previous build.
     * 
     */
    public static String RegressionTrigger_HelpText() {
        return holder.format("RegressionTrigger.HelpText");
    }

    /**
     * An email will be sent any time there is a regression. A build is considered to regress whenever it hasmore failures than the previous build.
     * 
     */
    public static Localizable _RegressionTrigger_HelpText() {
        return new Localizable(holder, "RegressionTrigger.HelpText");
    }

    /**
     * An email will be sent if the build status is "Failure" for two or more builds in a row.
     * 
     */
    public static String StillFailingTrigger_HelpText() {
        return holder.format("StillFailingTrigger.HelpText");
    }

    /**
     * An email will be sent if the build status is "Failure" for two or more builds in a row.
     * 
     */
    public static Localizable _StillFailingTrigger_HelpText() {
        return new Localizable(holder, "StillFailingTrigger.HelpText");
    }

    /**
     * Allows the user to define a script which must have the last line resolve to a true or false which willindicate whether the trigger should cause an email to be sent or not.
     * 
     */
    public static String ScriptTrigger_HelpText() {
        return holder.format("ScriptTrigger.HelpText");
    }

    /**
     * Allows the user to define a script which must have the last line resolve to a true or false which willindicate whether the trigger should cause an email to be sent or not.
     * 
     */
    public static Localizable _ScriptTrigger_HelpText() {
        return new Localizable(holder, "ScriptTrigger.HelpText");
    }

    /**
     * An email will be sent if the build status is "Successful".If the "Fixed" trigger is configured, and the previous build status was "Failure" or "Unstable",then the "Fixed" trigger will send an email instead.
     * 
     */
    public static String SuccessTrigger_HelpText() {
        return holder.format("SuccessTrigger.HelpText");
    }

    /**
     * An email will be sent if the build status is "Successful".If the "Fixed" trigger is configured, and the previous build status was "Failure" or "Unstable",then the "Fixed" trigger will send an email instead.
     * 
     */
    public static Localizable _SuccessTrigger_HelpText() {
        return new Localizable(holder, "SuccessTrigger.HelpText");
    }

    /**
     * An email will be sent when the build begins.
     * 
     */
    public static String PreBuildTrigger_HelpText() {
        return holder.format("PreBuildTrigger.HelpText");
    }

    /**
     * An email will be sent when the build begins.
     * 
     */
    public static Localizable _PreBuildTrigger_HelpText() {
        return new Localizable(holder, "PreBuildTrigger.HelpText");
    }

}
