/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.text.SimpleTemplateEngine;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ScriptSandbox;
import hudson.plugins.emailext.plugins.content.EmailExtScript;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptContent
extends DataBoundTokenMacro {
    private static final Logger LOGGER = Logger.getLogger(ScriptContent.class.getName());
    @DataBoundTokenMacro.Parameter
    public String script = "";
    private static final String DEFAULT_TEMPLATE_NAME = "groovy-html.template";
    @DataBoundTokenMacro.Parameter
    public String template = "groovy-html.template";
    private static final String EMAIL_TEMPLATES_DIRECTORY = "email-templates";
    public static final String MACRO_NAME = "SCRIPT";

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String result;
        InputStream inputStream;
        block7: {
            inputStream = null;
            result = "";
            try {
                if (!StringUtils.isEmpty((String)this.script)) {
                    inputStream = this.getFileInputStream(this.script);
                    result = this.executeScript(context, listener, inputStream);
                    break block7;
                }
                inputStream = this.getFileInputStream(this.template);
                result = this.renderTemplate(context, listener, inputStream);
            }
            catch (FileNotFoundException e) {
                String missingScriptError = this.generateMissingFile(this.script, this.template);
                LOGGER.log(Level.SEVERE, missingScriptError);
                result = missingScriptError;
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (GroovyRuntimeException e2) {
                result = "Error in script or template: " + e2.toString();
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    private String generateMissingFile(String script, String template) {
        if (!StringUtils.isEmpty((String)script)) {
            return "Script [" + script + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
        }
        return "Template [" + template + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
    }

    private InputStream getFileInputStream(String fileName) throws FileNotFoundException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + fileName);
        if (inputStream == null) {
            File scriptsFolder = new File(Hudson.getInstance().getRootDir(), EMAIL_TEMPLATES_DIRECTORY);
            File scriptFile = new File(scriptsFolder, fileName);
            inputStream = new FileInputStream(scriptFile);
        }
        return inputStream;
    }

    private String renderTemplate(AbstractBuild<?, ?> build, TaskListener listener, InputStream templateStream) throws IOException {
        String result;
        HashMap<String, Object> binding = new HashMap<String, Object>();
        ExtendedEmailPublisher publisher = (ExtendedEmailPublisher)build.getProject().getPublishersList().get(ExtendedEmailPublisher.class);
        binding.put("build", build);
        binding.put("listener", listener);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("rooturl", publisher.getDescriptor().getHudsonUrl());
        binding.put("project", build.getParent());
        GroovyShell shell = this.createEngine(publisher, Collections.EMPTY_MAP);
        SimpleTemplateEngine engine = new SimpleTemplateEngine(shell);
        try {
            result = engine.createTemplate((Reader)new InputStreamReader(templateStream)).make(binding).toString();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            result = "Exception raised during template rendering: " + e.getMessage() + "\n\n" + sw.toString();
        }
        return result;
    }

    private String executeScript(AbstractBuild<?, ?> build, TaskListener listener, InputStream scriptStream) throws IOException {
        String result = "";
        HashMap<String, Object> binding = new HashMap<String, Object>();
        ExtendedEmailPublisher publisher = (ExtendedEmailPublisher)build.getProject().getPublishersList().get(ExtendedEmailPublisher.class);
        binding.put("build", build);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("project", build.getParent());
        binding.put("rooturl", publisher.getDescriptor().getHudsonUrl());
        GroovyShell shell = this.createEngine(publisher, binding);
        Object res = shell.evaluate((Reader)new InputStreamReader(scriptStream));
        if (res != null) {
            result = res.toString();
        }
        return result;
    }

    private GroovyShell createEngine(ExtendedEmailPublisher publisher, Map<String, Object> variables) throws FileNotFoundException, IOException {
        ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
        ScriptSandbox sandbox = null;
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setScriptBaseClass(EmailExtScript.class.getCanonicalName());
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
        if (publisher.getDescriptor().isSecurityEnabled()) {
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
            sandbox = new ScriptSandbox();
        }
        Binding binding = new Binding();
        for (Map.Entry<String, Object> e : variables.entrySet()) {
            binding.setVariable(e.getKey(), e.getValue());
        }
        GroovyShell shell = new GroovyShell(cl, binding, cc);
        if (sandbox != null) {
            sandbox.register();
        }
        return shell;
    }

    public boolean hasNestedContent() {
        return false;
    }
}

