/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectInfo;
import org.jenkinsci.plugins.envinject.Messages;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectVariableGetter;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectBuilder
extends Builder
implements Serializable {
    public static final String ENVINJECT_BUILDER_ACTION_NAME = "EnvInjectBuilderaction";
    private EnvInjectInfo info;

    @DataBoundConstructor
    public EnvInjectBuilder(String propertiesFilePath, String propertiesContent) {
        this.info = new EnvInjectInfo(propertiesFilePath, propertiesContent);
    }

    public EnvInjectInfo getInfo() {
        return this.info;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        logger.info("Injecting environment variables from a build step.");
        FilePath ws = build.getWorkspace();
        EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(ws);
        EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
        try {
            SCM scm;
            EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
            Map<String, String> previousEnvVars = variableGetter.getEnvVarsPreviousSteps(build, logger);
            HashMap<String, String> variables = new HashMap<String, String>(previousEnvVars);
            if (ws != null) {
                variables.put("WORKSPACE", ws.getRemote());
            }
            if ((scm = build.getProject().getScm()) != null) {
                scm.buildEnvVars(build, variables);
            }
            variables.putAll(this.getAndAddBuildVariables(build));
            Map<String, String> propertiesEnvVars = envInjectEnvVarsService.getEnvVarsPropertiesProperty(ws, logger, this.info.getPropertiesFilePath(), this.info.getPropertiesContentMap(), variables);
            final Map<String, String> resultVariables = envInjectEnvVarsService.getMergedVariables(variables, propertiesEnvVars);
            build.addAction((Action)new EnvironmentContributingAction(){

                public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
                    env.putAll(resultVariables);
                }

                public String getIconFileName() {
                    return null;
                }

                public String getDisplayName() {
                    return EnvInjectBuilder.ENVINJECT_BUILDER_ACTION_NAME;
                }

                public String getUrlName() {
                    return null;
                }
            });
            envInjectActionSetter.addEnvVarsToEnvInjectBuildAction(build, resultVariables);
        }
        catch (Throwable throwable) {
            logger.error("[EnvInject] - [ERROR] - Problems occurs on injecting env vars as a build step: " + throwable.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    private Map<String, String> getAndAddBuildVariables(AbstractBuild build) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(build.getBuildVariables());
        FilePath ws = build.getWorkspace();
        if (ws != null) {
            result.put("WORKSPACE", ws.getRemote());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return Messages.envinject_addVars_displayName();
        }

        public String getHelpFile() {
            return "/plugin/envinject/help-buildStep.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

