/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectNodeProperty;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectMasterEnvVarsSetter;

@Extension
public class EnvInjectComputerListener
extends ComputerListener
implements Serializable {
    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        try {
            EnvInjectNodeProperty envInjectNodeProperty;
            EnvInjectLogger logger = new EnvInjectLogger(listener);
            EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
            FilePath nodePath = c.getNode().getRootPath();
            if (nodePath == null) {
                return;
            }
            boolean unsetSystemVariables = false;
            HashMap<String, String> globalPropertiesEnvVars = new HashMap<String, String>();
            Map nodeEnvVars = (Map)nodePath.act((Callable)new Callable<Map<String, String>, IOException>(){

                public Map<String, String> call() throws IOException {
                    return EnvVars.masterEnvVars;
                }
            });
            for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
                if (!(nodeProperty instanceof EnvInjectNodeProperty)) continue;
                HashMap<String, String> masterEnvVars = new HashMap();
                try {
                    masterEnvVars = (Map)Hudson.getInstance().getRootPath().act((Callable)new Callable<Map<String, String>, Throwable>(){

                        public Map<String, String> call() throws Throwable {
                            return EnvVars.masterEnvVars;
                        }
                    });
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                envInjectNodeProperty = (EnvInjectNodeProperty)nodeProperty;
                unsetSystemVariables = envInjectNodeProperty.isUnsetSystemVariables();
                globalPropertiesEnvVars.putAll(envInjectEnvVarsService.getEnvVarsPropertiesProperty(c.getNode().getRootPath(), logger, envInjectNodeProperty.getPropertiesFilePath(), null, masterEnvVars));
            }
            Node slave = Hudson.getInstance().getNode(c.getName());
            if (slave != null) {
                for (NodeProperty nodeProperty : c.getNode().getNodeProperties()) {
                    if (!(nodeProperty instanceof EnvInjectNodeProperty)) continue;
                    envInjectNodeProperty = (EnvInjectNodeProperty)nodeProperty;
                    unsetSystemVariables = envInjectNodeProperty.isUnsetSystemVariables();
                    globalPropertiesEnvVars.putAll(envInjectEnvVarsService.getEnvVarsPropertiesProperty(c.getNode().getRootPath(), logger, envInjectNodeProperty.getPropertiesFilePath(), null, nodeEnvVars));
                }
            }
            EnvVars envVars2Set = new EnvVars();
            if (!unsetSystemVariables) {
                envVars2Set.putAll(nodeEnvVars);
            }
            envVars2Set.putAll(globalPropertiesEnvVars);
            nodePath.act((Callable)new EnvInjectMasterEnvVarsSetter(envVars2Set));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (EnvInjectException e) {
            e.printStackTrace();
        }
    }
}

