/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectJobPropertyInfo;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordEntry;
import org.jenkinsci.plugins.envinject.Messages;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributor;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributorDescriptor;
import org.jenkinsci.plugins.envinject.service.EnvInjectContributorManagement;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectJobProperty<T extends Job<?, ?>>
extends JobProperty<T> {
    private EnvInjectJobPropertyInfo info;
    private boolean on;
    private boolean keepJenkinsSystemVariables;
    private boolean keepBuildVariables;
    private boolean injectGlobalPasswords;
    private EnvInjectPasswordEntry[] passwordEntries;
    private EnvInjectJobPropertyContributor[] contributors;
    private transient EnvInjectJobPropertyContributor[] contributorsComputed;
    @Deprecated
    private transient boolean keepSystemVariables;

    public EnvInjectJobPropertyInfo getInfo() {
        return this.info;
    }

    public boolean isOn() {
        return this.on;
    }

    public boolean isKeepSystemVariables() {
        return this.keepSystemVariables;
    }

    public boolean isKeepJenkinsSystemVariables() {
        return this.keepJenkinsSystemVariables;
    }

    public boolean isKeepBuildVariables() {
        return this.keepBuildVariables;
    }

    public boolean isInjectGlobalPasswords() {
        return this.injectGlobalPasswords;
    }

    public EnvInjectPasswordEntry[] getPasswordEntries() {
        return this.passwordEntries;
    }

    public EnvInjectJobPropertyContributor[] getContributors() {
        if (this.contributorsComputed == null) {
            try {
                this.contributorsComputed = this.computeEnvInjectContributors();
            }
            catch (EnvInjectException e) {
                e.printStackTrace();
            }
            this.contributors = this.contributorsComputed;
        }
        return this.contributors;
    }

    private EnvInjectJobPropertyContributor[] computeEnvInjectContributors() throws EnvInjectException {
        DescriptorExtensionList<EnvInjectJobPropertyContributor, EnvInjectJobPropertyContributorDescriptor> descriptors = EnvInjectJobPropertyContributor.all();
        if (this.contributors != null && this.contributors.length == descriptors.size()) {
            return this.contributors;
        }
        EnvInjectContributorManagement envInjectContributorManagement = new EnvInjectContributorManagement();
        EnvInjectJobPropertyContributor[] contributorsInstance = envInjectContributorManagement.getNewContributorsInstance();
        if (this.contributors == null || this.contributors.length == 0) {
            return contributorsInstance;
        }
        ArrayList<EnvInjectJobPropertyContributor> result = new ArrayList<EnvInjectJobPropertyContributor>();
        for (EnvInjectJobPropertyContributor contributor1 : contributorsInstance) {
            for (EnvInjectJobPropertyContributor contributor2 : this.contributors) {
                if (contributor1.getDescriptor().getClass() == contributor2.getDescriptor().getClass()) {
                    result.add(contributor2);
                    continue;
                }
                result.add(contributor1);
            }
        }
        return result.toArray(new EnvInjectJobPropertyContributor[result.size()]);
    }

    public void setInfo(EnvInjectJobPropertyInfo info) {
        this.info = info;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public void setKeepJenkinsSystemVariables(boolean keepJenkinsSystemVariables) {
        this.keepJenkinsSystemVariables = keepJenkinsSystemVariables;
    }

    public void setKeepBuildVariables(boolean keepBuildVariables) {
        this.keepBuildVariables = keepBuildVariables;
    }

    public void setInjectGlobalPasswords(boolean injectGlobalPasswords) {
        this.injectGlobalPasswords = injectGlobalPasswords;
    }

    public void setPasswordEntries(EnvInjectPasswordEntry[] passwordEntries) {
        this.passwordEntries = passwordEntries;
    }

    public void setContributors(EnvInjectJobPropertyContributor[] jobPropertyContributors) {
        this.contributors = jobPropertyContributors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "[Environment Inject] -" + Messages.envinject_set_displayName();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/envinject/help.html";
        }

        public EnvInjectJobProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Object onObject = formData.get("on");
            if (onObject != null) {
                EnvInjectJobProperty envInjectJobProperty = new EnvInjectJobProperty();
                EnvInjectJobPropertyInfo info = (EnvInjectJobPropertyInfo)req.bindParameters(EnvInjectJobPropertyInfo.class, "envInjectInfoJobProperty.");
                envInjectJobProperty.setInfo(info);
                envInjectJobProperty.setOn(true);
                if (onObject instanceof JSONObject) {
                    JSONObject onJSONObject = (JSONObject)onObject;
                    envInjectJobProperty.setKeepJenkinsSystemVariables(onJSONObject.getBoolean("keepJenkinsSystemVariables"));
                    envInjectJobProperty.setKeepBuildVariables(onJSONObject.getBoolean("keepBuildVariables"));
                    envInjectJobProperty.setInjectGlobalPasswords(onJSONObject.getBoolean("injectGlobalPasswords"));
                    List passwordEntries = req.bindParametersToList(EnvInjectPasswordEntry.class, "envInjectPasswordEntry.");
                    envInjectJobProperty.setPasswordEntries(passwordEntries.toArray(new EnvInjectPasswordEntry[passwordEntries.size()]));
                    this.setContributors(req, envInjectJobProperty, onJSONObject);
                    return envInjectJobProperty;
                }
            }
            return null;
        }

        private void setContributors(StaplerRequest req, EnvInjectJobProperty envInjectJobProperty, JSONObject onJSONObject) {
            if (!onJSONObject.containsKey((Object)"contributors")) {
                envInjectJobProperty.setContributors(new EnvInjectJobPropertyContributor[0]);
            } else {
                JSONArray contribJSON;
                try {
                    contribJSON = onJSONObject.getJSONArray("contributors");
                }
                catch (JSONException jsone) {
                    contribJSON = onJSONObject.getJSONObject("contributors");
                }
                List contributions = req.bindJSONToList(EnvInjectJobPropertyContributor.class, (Object)contribJSON);
                EnvInjectJobPropertyContributor[] contributionsArray = contributions.toArray(new EnvInjectJobPropertyContributor[contributions.size()]);
                envInjectJobProperty.setContributors(contributionsArray);
            }
        }

        public DescriptorExtensionList<EnvInjectJobPropertyContributor, EnvInjectJobPropertyContributorDescriptor> getEnvInjectContributors() {
            return EnvInjectJobPropertyContributor.all();
        }

        public EnvInjectJobPropertyContributor[] getContributorsInstance() {
            EnvInjectContributorManagement envInjectContributorManagement = new EnvInjectContributorManagement();
            try {
                return envInjectContributorManagement.getNewContributorsInstance();
            }
            catch (EnvInjectException e) {
                e.printStackTrace();
                return null;
            }
        }

        public boolean isEnvInjectContributionActivated() {
            EnvInjectContributorManagement envInjectContributorManagement = new EnvInjectContributorManagement();
            return envInjectContributorManagement.isEnvInjectContributionActivated();
        }
    }
}

