/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.buildwrapper;

import hudson.Extension;
import hudson.Launcher;
import hudson.console.LineTransformationOutputStream;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordEntry;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectPasswordWrapper
extends BuildWrapper {
    private List<EnvInjectPasswordEntry> passwords;

    @DataBoundConstructor
    public EnvInjectPasswordWrapper(List<EnvInjectPasswordEntry> passwords) {
        this.passwords = passwords;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new BuildWrapper.Environment(){};
    }

    public OutputStream decorateLogger(AbstractBuild build, OutputStream logger) throws IOException, InterruptedException, Run.RunnerAbortedException {
        ArrayList<String> passwords2decorate = new ArrayList<String>();
        if (this.passwords != null) {
            for (EnvInjectPasswordEntry passwordEntry : this.passwords) {
                passwords2decorate.add(passwordEntry.getValue().getPlainText());
            }
        }
        return new MaskPasswordsOutputStream(logger, passwords2decorate);
    }

    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        if (this.passwords != null) {
            for (EnvInjectPasswordEntry passwordEntry : this.passwords) {
                variables.put(passwordEntry.getName(), passwordEntry.getValue().getPlainText());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return false;
        }

        public String getDisplayName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MaskPasswordsOutputStream
    extends LineTransformationOutputStream {
        private static final String MASKED_PASSWORD = "********";
        private final OutputStream logger;
        private final Pattern passwordsAsPattern;

        MaskPasswordsOutputStream(OutputStream logger, Collection<String> passwords) {
            this.logger = logger;
            if (passwords != null && passwords.size() > 0) {
                StringBuilder regex = new StringBuilder().append('(');
                int nbMaskedPasswords = 0;
                for (String password : passwords) {
                    if (!StringUtils.isNotEmpty((String)password)) continue;
                    regex.append(Pattern.quote(password));
                    regex.append('|');
                    ++nbMaskedPasswords;
                }
                if (nbMaskedPasswords++ >= 1) {
                    regex.deleteCharAt(regex.length() - 1);
                    regex.append(')');
                    this.passwordsAsPattern = Pattern.compile(regex.toString());
                } else {
                    this.passwordsAsPattern = null;
                }
            } else {
                this.passwordsAsPattern = null;
            }
        }

        protected void eol(byte[] bytes, int len) throws IOException {
            String line = new String(bytes, 0, len);
            if (this.passwordsAsPattern != null) {
                line = this.passwordsAsPattern.matcher(line).replaceAll(MASKED_PASSWORD);
            }
            this.logger.write(line.getBytes());
        }
    }
}

