/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.migration;

import hudson.Extension;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Hudson;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import hudson.plugins.envfile.EnvFileBuildWrapper;
import hudson.plugins.setenv.SetEnvBuildWrapper;
import hudson.tasks.BuildWrapper;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectBuildWrapper;
import org.jenkinsci.plugins.envinject.migration.EnvInjectMigrationBuildWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class EnvInjectMigrationWrappers
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(EnvInjectMigrationWrappers.class.getName());

    private boolean containAPluginToMigrate(Class<? extends BuildWrapper> wrapperClass) {
        return EnvFileBuildWrapper.class.isAssignableFrom(wrapperClass) || SetEnvBuildWrapper.class.isAssignableFrom(wrapperClass);
    }

    public void onLoaded() {
        List items = Hudson.getInstance().getItems();
        for (TopLevelItem item : items) {
            try {
                if (!(item instanceof BuildableItemWithBuildWrappers)) continue;
                BuildableItemWithBuildWrappers buildableItemWithBuildWrappers = (BuildableItemWithBuildWrappers)item;
                DescribableList wrappersList = buildableItemWithBuildWrappers.getBuildWrappersList();
                Iterator buildWrapperIterator = wrappersList.iterator();
                while (buildWrapperIterator.hasNext()) {
                    BuildWrapper buildWrapper = (BuildWrapper)buildWrapperIterator.next();
                    if (!this.containAPluginToMigrate(buildWrapper.getClass())) continue;
                    EnvInjectMigrationBuildWrapper oldWrapper = (EnvInjectMigrationBuildWrapper)buildWrapper;
                    buildWrapperIterator.remove();
                    this.addOrModifyEnvInjectBuildWrapper(buildableItemWithBuildWrappers, oldWrapper.getEnvInjectBuildWrapper());
                    buildableItemWithBuildWrappers.save();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Can't migrate old plugins to EnvInject plugin for the item %s", item.getName());
                e.printStackTrace();
            }
            catch (EnvInjectException e) {
                LOGGER.log(Level.SEVERE, "Can't migrate old plugins to EnvInject plugin for the item %s", item.getName());
                e.printStackTrace();
            }
        }
    }

    private void addOrModifyEnvInjectBuildWrapper(BuildableItemWithBuildWrappers buildableItemWithBuildWrappers, EnvInjectBuildWrapper envInjectBuildWrapper) throws EnvInjectException {
        DescribableList wrappersList = buildableItemWithBuildWrappers.getBuildWrappersList();
        Iterator buildWrapperIterator = wrappersList.iterator();
        while (buildWrapperIterator.hasNext()) {
            BuildWrapper buildWrapper = (BuildWrapper)buildWrapperIterator.next();
            if (!buildWrapper.getClass().isAssignableFrom(EnvInjectBuildWrapper.class)) continue;
            buildWrapperIterator.remove();
        }
        try {
            wrappersList.add((Object)envInjectBuildWrapper);
        }
        catch (IOException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
    }
}

