/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.model.Action;
import hudson.model.InvisibleAction;
import java.net.MalformedURLException;
import java.net.URL;

public class FitnesseBuildAction
extends InvisibleAction
implements Action {
    public static final FitnesseBuildAction NULL_ACTION = new FitnesseBuildAction(true, null, 0);
    private final String fitnesseHost;
    private final int fitnessePort;
    private final boolean fitnesseStarted;
    private final boolean enableSsl;

    public FitnesseBuildAction(boolean fitnesseStarted, String fitnesseHost, int fitnessePort) {
        this(fitnesseStarted, fitnesseHost, fitnessePort, false);
    }

    public FitnesseBuildAction(boolean fitnesseStarted, String fitnesseHost, int fitnessePort, boolean enableSsl) {
        this.fitnesseStarted = fitnesseStarted;
        this.fitnesseHost = fitnesseHost;
        this.fitnessePort = fitnessePort;
        this.enableSsl = enableSsl;
    }

    public String getLinkFor(String fitnessePage) {
        return this.getLinkFor(fitnessePage, null, fitnessePage);
    }

    public String getLinkFor(String fitnessePage, String hudsonHost) {
        return this.getLinkFor(fitnessePage, hudsonHost, fitnessePage);
    }

    public String getLinkFor(String fitnessePage, String hudsonHost, String display) {
        if (this.fitnesseStarted) {
            return fitnessePage;
        }
        String host = this.fitnesseHost;
        if (hudsonHost != null && "localhost".equals(this.fitnesseHost)) {
            try {
                host = new URL(hudsonHost).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return String.format("<a href=\"%s://%s:%s/%s\">%s</a>", this.enableSsl ? "https" : "http", host, this.fitnessePort, fitnessePage, display);
    }
}

