/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.fitnesse.FitnesseExecutor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class FitnesseBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 931934300658830569L;
    public static final String START_FITNESSE = "fitnesseStart";
    public static final String FITNESSE_HOST = "fitnesseHost";
    public static final String FITNESSE_PORT = "fitnessePort";
    public static final String FITNESSE_USERNAME = "fitnesseUsername";
    public static final String FITNESSE_PASSWORD = "fitnessePassword";
    public static final String FITNESSE_PORT_REMOTE = "fitnessePortRemote";
    public static final String FITNESSE_ENABLE_SSL = "fitnesseEnableSsl";
    public static final String FITNESSE_PORT_LOCAL = "fitnessePortLocal";
    public static final String FITNESSE_ADDITIONAL_OPTIONS = "additionalFitnesseOptions";
    public static final String JAVA_OPTS = "fitnesseJavaOpts";
    public static final String FITNESSE_JDK = "fitnesseJdk";
    public static final String PATH_TO_JAR = "fitnessePathToJar";
    public static final String PATH_TO_ROOT = "fitnessePathToRoot";
    public static final String TARGET_PAGE = "fitnesseTargetPage";
    public static final String PARTITION_ENABLED = "fitnessePartitionEnabled";
    public static final String PARTITION_COUNT = "fitnessePartitionCount";
    public static final String PARTITION_INDEX = "fitnessePartitionIndex";
    public static final String PARTITION_INDEX_FILE = "fitnessePartitionIndexFile";
    public static final String TARGET_IS_SUITE = "fitnesseTargetIsSuite";
    public static final String PATH_TO_RESULTS = "fitnessePathToXmlResultsOut";
    public static final String PATH_TO_JUNIT_RESULTS = "fitnessePathToJunitResultsOut";
    public static final String HTTP_TIMEOUT = "fitnesseHttpTimeout";
    public static final String TEST_TIMEOUT = "fitnesseTestTimeout";
    public static final String JAVA_WORKING_DIRECTORY = "fitnesseJavaWorkingDirectory";
    static final int _URL_READ_TIMEOUT_MILLIS = 60000;
    static final String _LOCALHOST = "localhost";
    static final String _HOSTNAME_SLAVE_PROPERTY = "HOST_NAME";
    public Map<String, String> options;

    @DataBoundConstructor
    public FitnesseBuilder(Map<String, String> options) {
        this.options = options;
    }

    private String getOption(String key, String valueIfKeyNotFound) {
        String value;
        if (this.options.containsKey(key) && (value = this.options.get(key)) != null && !"".equals(value)) {
            return value;
        }
        return valueIfKeyNotFound;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getOption(String key, String valueIfKeyNotFound, EnvVars environment) {
        if (environment == null) return this.getOption(key, valueIfKeyNotFound);
        if (!this.options.containsKey(key)) return valueIfKeyNotFound;
        String value = this.options.get(key);
        if (value == null || "".equals(value)) return valueIfKeyNotFound;
        return Util.replaceMacro((String)value, (Map)environment);
    }

    public boolean getFitnesseStart() {
        return Boolean.parseBoolean(this.getOption(START_FITNESSE, "False"));
    }

    public boolean getFitnesseSsl() {
        return Boolean.parseBoolean(this.getOption(FITNESSE_ENABLE_SSL, "False"));
    }

    public String getFitnesseHost() {
        if (this.getFitnesseStart()) {
            return _LOCALHOST;
        }
        return this.getOption(FITNESSE_HOST, "unknown_host");
    }

    public String getFitnesseHost(EnvVars environment) {
        if (this.getFitnesseStart()) {
            return _LOCALHOST;
        }
        return this.getOption(FITNESSE_HOST, "unknown_host", environment);
    }

    public String getFitnesseHost(Run<?, ?> build, EnvVars environment) throws IOException, InterruptedException {
        if (this.getFitnesseStart()) {
            if (build != null && environment != null && environment.get((Object)_HOSTNAME_SLAVE_PROPERTY) != null) {
                return (String)environment.get((Object)_HOSTNAME_SLAVE_PROPERTY);
            }
            return _LOCALHOST;
        }
        return this.getOption(FITNESSE_HOST, "unknown_host", environment);
    }

    public String getFitnesseJdk() {
        return this.getOption(FITNESSE_JDK, "");
    }

    public String getFitnesseJdk(EnvVars environment) {
        return this.getOption(FITNESSE_JDK, "", environment);
    }

    public String getFitnesseJavaOpts() {
        return this.getOption(JAVA_OPTS, "");
    }

    public String getFitnesseJavaOpts(EnvVars environment) {
        return this.getOption(JAVA_OPTS, "", environment);
    }

    public String getFitnesseJavaWorkingDirectory() {
        String fitnessePathToJar = this.getFitnessePathToJar();
        String fitnesseJarDir = "";
        if (!"".equals(fitnessePathToJar)) {
            File jarFile = new File(fitnessePathToJar);
            if (jarFile.exists()) {
                fitnesseJarDir = jarFile.getParentFile().getAbsolutePath();
            } else {
                fitnesseJarDir = jarFile.getParent();
                if (fitnesseJarDir == null) {
                    fitnesseJarDir = "";
                }
            }
        }
        return this.getOption(JAVA_WORKING_DIRECTORY, fitnesseJarDir);
    }

    public String getFitnessePort() {
        return this.getOption(FITNESSE_PORT_REMOTE, this.getOption(FITNESSE_PORT_LOCAL, this.getOption(FITNESSE_PORT, "-1")));
    }

    public int getFitnessePort(EnvVars environment) {
        return Integer.parseInt(this.getOption(FITNESSE_PORT_REMOTE, this.getOption(FITNESSE_PORT_LOCAL, this.getOption(FITNESSE_PORT, "-1", environment), environment), environment));
    }

    public String getFitnesseUsername() {
        return this.getOption(FITNESSE_USERNAME, "");
    }

    public String getFitnessePassword() {
        return this.getOption(FITNESSE_PASSWORD, "");
    }

    public String getFitnessePathToJar() {
        return this.getOption(PATH_TO_JAR, "fitnesse.jar");
    }

    public String getAdditionalFitnesseOptions() {
        String sanitizedOptions = this.getOption(FITNESSE_ADDITIONAL_OPTIONS, "");
        if (sanitizedOptions.length() > 2 && sanitizedOptions.startsWith("\"") && sanitizedOptions.endsWith("\"")) {
            sanitizedOptions = sanitizedOptions.substring(1, sanitizedOptions.length() - 1);
        }
        return sanitizedOptions;
    }

    public String getFitnessePathToRoot() {
        return this.getOption(PATH_TO_ROOT, "FitNesseRoot");
    }

    public String getFitnessePathToRoot(EnvVars environment) {
        return this.getOption(PATH_TO_ROOT, "FitNesseRoot", environment);
    }

    public String getFitnesseTargetPage() {
        return this.getOption(TARGET_PAGE, "");
    }

    public String getFitnesseTargetPage(EnvVars environment) {
        return this.getOption(TARGET_PAGE, "", environment);
    }

    public boolean getFitnessePartitionEnabled() {
        return Boolean.parseBoolean(this.getOption(PARTITION_ENABLED, "False"));
    }

    public int getFitnessePartitionCount() {
        try {
            return Integer.parseInt(this.getOption(PARTITION_COUNT, "0"));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int getFitnessePartitionIndex() {
        try {
            int index = Integer.parseInt(this.getOption(PARTITION_INDEX, "0"));
            if (index < this.getFitnessePartitionCount()) {
                return index;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public String getFitnessePartitionIndexFile() {
        return this.getOption(PARTITION_INDEX_FILE, "");
    }

    public String getFitnessePathToXmlResultsOut() {
        return this.getOption(PATH_TO_RESULTS, "fitnesse-results.xml");
    }

    public String getFitnessePathToXmlResultsOut(EnvVars environment) {
        return this.getOption(PATH_TO_RESULTS, "fitnesse-results.xml", environment);
    }

    public String getFitnessePathToJunitResultsOut() {
        return this.getOption(PATH_TO_JUNIT_RESULTS, "");
    }

    public String getFitnessePathToJunitResultsOut(EnvVars environment) {
        return this.getOption(PATH_TO_JUNIT_RESULTS, "", environment);
    }

    public String getFitnesseHttpTimeout() {
        return this.getOption(HTTP_TIMEOUT, String.valueOf(60000));
    }

    public int getFitnesseHttpTimeout(EnvVars environment) {
        return Integer.parseInt(this.getOption(HTTP_TIMEOUT, String.valueOf(60000), environment));
    }

    public int getFitnesseTestTimeout() {
        return Integer.parseInt(this.getOption(TEST_TIMEOUT, String.valueOf(60000)));
    }

    public int getFitnesseTestTimeout(EnvVars environment) {
        return Integer.parseInt(this.getOption(TEST_TIMEOUT, String.valueOf(60000), environment));
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        HashMap<String, String> optionsWithoutPassword = new HashMap<String, String>();
        optionsWithoutPassword.putAll(this.options);
        optionsWithoutPassword.remove(FITNESSE_PASSWORD);
        listener.getLogger().println(this.getClass().getName() + ": " + optionsWithoutPassword);
        FitnesseExecutor fitnesseExecutor = new FitnesseExecutor(this, listener, build.getEnvironment(listener));
        fitnesseExecutor.execute(launcher, workspace, build);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckFitnesseHost(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify the host of the fitnesse instance.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAdditionalFitnesseOptions(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() > 0 && (value.contains("-r") || value.contains("-p") || value.contains("-d"))) {
                return FormValidation.error((String)"Please use the appropriate config fields to specify options for -r, -d, and -p.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePort(@QueryParameter String value) throws IOException, ServletException {
            block4: {
                if (value.length() == 0) {
                    return FormValidation.error((String)"Please specify the fitnesse port.");
                }
                try {
                    int intValue = Integer.parseInt(value);
                    if (intValue < 1) {
                        return FormValidation.error((String)"Port must be a positive integer.");
                    }
                }
                catch (NumberFormatException e) {
                    if (value.startsWith("$")) break block4;
                    return FormValidation.error((String)"Port must be a number.");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnesseJdk(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.ok((String)"Defaults to project's JDK");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnesseJavaOpts(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnesseJavaWorkingDirectory(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.ok((String)"Location of fitnesse.jar will be used as java working directory.");
            }
            if (!new File(value).exists()) {
                return FormValidation.error((String)"Path does not exist.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePathToJar(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify the path to 'fitnesse.jar'.");
            }
            if (!value.endsWith("fitnesse.jar") && new File(value, "fitnesse.jar").exists()) {
                return FormValidation.warning((String)"Path does not end with 'fitnesse.jar': is that correct?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePathToRoot(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify the location of 'FitNesseRoot'.");
            }
            if (!value.endsWith("FitNesseRoot") && new File(value, "FitNesseRoot").exists()) {
                return FormValidation.warning((String)"Path does not end with 'FitNesseRoot': is that correct?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnesseTargetPage(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify a page to execute.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePartitionCount(@QueryParameter String value) {
            try {
                if (Integer.parseInt(value) < 2) {
                    throw new Exception("");
                }
            }
            catch (Exception ex) {
                return FormValidation.warning((String)"If you don't use a numeric value greater than 1, partitioning will not be applied.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePartitionIndex(@QueryParameter String value) {
            try {
                if (Integer.parseInt(value) < 0) {
                    throw new Exception("");
                }
            }
            catch (Exception ex) {
                return FormValidation.warning((String)"If you don't provide a numeric value less than partition count, it will consider index 0.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnesseHttpTimeout(@QueryParameter String value) throws IOException, ServletException {
            block4: {
                if (value.length() == 0) {
                    return FormValidation.ok((String)"Default HTTP timeout 60000ms will be used.");
                }
                try {
                    if (Integer.parseInt(value) < 0) {
                        return FormValidation.error((String)"HTTP timeout must be a positive integer.");
                    }
                }
                catch (NumberFormatException e) {
                    if (value.startsWith("$")) break block4;
                    return FormValidation.error((String)"HTTP timeout must be a number.");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnesseTestTimeout(@QueryParameter String value) throws IOException, ServletException {
            block4: {
                if (value.length() == 0) {
                    return FormValidation.ok((String)"Default test timeout 60000ms will be used.");
                }
                try {
                    if (Integer.parseInt(value) < 0) {
                        return FormValidation.error((String)"Test timeout must be a positive integer.");
                    }
                }
                catch (NumberFormatException e) {
                    if (value.startsWith("$")) break block4;
                    return FormValidation.error((String)"Test timeout must be a number.");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePathToXmlResultsOut(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify where to write fitnesse results to.");
            }
            if (!value.endsWith("xml")) {
                return FormValidation.warning((String)"File does not end with 'xml': is that correct?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFitnessePathToJunitResultsOut(@QueryParameter String value) throws IOException, ServletException {
            if (value.trim().length() > 0 && !value.endsWith("xml")) {
                return FormValidation.error((String)"File name does not end with 'xml': will be ignored");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute FitNesse tests";
        }

        public FitnesseBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.computePartitioningData(formData);
            String startFitnesseValue = formData.getJSONObject(FitnesseBuilder.START_FITNESSE).getString("value");
            if (Boolean.parseBoolean(startFitnesseValue)) {
                return this.newFitnesseBuilder(startFitnesseValue, this.collectFormData(formData, new String[]{FitnesseBuilder.FITNESSE_JDK, FitnesseBuilder.JAVA_OPTS, FitnesseBuilder.JAVA_WORKING_DIRECTORY, FitnesseBuilder.PATH_TO_JAR, FitnesseBuilder.PATH_TO_ROOT, FitnesseBuilder.FITNESSE_PORT_LOCAL, FitnesseBuilder.TARGET_PAGE, FitnesseBuilder.PARTITION_ENABLED, FitnesseBuilder.PARTITION_COUNT, FitnesseBuilder.PARTITION_INDEX, FitnesseBuilder.PARTITION_INDEX_FILE, FitnesseBuilder.HTTP_TIMEOUT, FitnesseBuilder.TEST_TIMEOUT, FitnesseBuilder.PATH_TO_RESULTS, FitnesseBuilder.PATH_TO_JUNIT_RESULTS, FitnesseBuilder.FITNESSE_ADDITIONAL_OPTIONS}));
            }
            return this.newFitnesseBuilder(startFitnesseValue, this.collectFormData(formData, new String[]{FitnesseBuilder.FITNESSE_HOST, FitnesseBuilder.FITNESSE_PORT_REMOTE, FitnesseBuilder.FITNESSE_USERNAME, FitnesseBuilder.FITNESSE_PASSWORD, FitnesseBuilder.FITNESSE_ENABLE_SSL, FitnesseBuilder.TARGET_PAGE, FitnesseBuilder.PARTITION_ENABLED, FitnesseBuilder.PARTITION_COUNT, FitnesseBuilder.PARTITION_INDEX, FitnesseBuilder.PARTITION_INDEX_FILE, FitnesseBuilder.HTTP_TIMEOUT, FitnesseBuilder.TEST_TIMEOUT, FitnesseBuilder.PATH_TO_RESULTS, FitnesseBuilder.PATH_TO_JUNIT_RESULTS}));
        }

        private void computePartitioningData(JSONObject formData) {
            try {
                int partitionCount = formData.getInt(FitnesseBuilder.PARTITION_COUNT);
                if (partitionCount <= 1) {
                    formData.put(FitnesseBuilder.PARTITION_ENABLED, (Object)false);
                    return;
                }
                formData.put(FitnesseBuilder.PARTITION_COUNT, (Object)partitionCount);
                formData.put(FitnesseBuilder.PARTITION_ENABLED, (Object)formData.getBoolean(FitnesseBuilder.PARTITION_ENABLED));
                try {
                    int partitionIndex = formData.getInt(FitnesseBuilder.PARTITION_INDEX);
                    partitionIndex = partitionIndex >= 0 && partitionIndex < partitionCount ? partitionIndex : 0;
                    formData.put(FitnesseBuilder.PARTITION_INDEX, (Object)partitionIndex);
                }
                catch (Exception ex1) {
                    formData.put(FitnesseBuilder.PARTITION_INDEX, (Object)0);
                }
            }
            catch (Exception ex) {
                formData.put(FitnesseBuilder.PARTITION_ENABLED, (Object)false);
                return;
            }
            if (formData.getString(FitnesseBuilder.PARTITION_INDEX_FILE).length() > 0) {
                formData.put(FitnesseBuilder.PARTITION_INDEX_FILE, formData.get(FitnesseBuilder.PARTITION_INDEX_FILE));
            }
        }

        private FitnesseBuilder newFitnesseBuilder(String startFitnesseValue, Map<String, String> collectedFormData) {
            collectedFormData.put(FitnesseBuilder.START_FITNESSE, startFitnesseValue);
            return new FitnesseBuilder(collectedFormData);
        }

        private Map<String, String> collectFormData(JSONObject formData, String[] keys) {
            HashMap<String, String> targetElements = new HashMap<String, String>();
            for (String key : keys) {
                String value = "";
                if (formData.has(key)) {
                    value = formData.getString(key);
                } else if (formData.getJSONObject(FitnesseBuilder.START_FITNESSE).get(key) != null) {
                    value = formData.getJSONObject(FitnesseBuilder.START_FITNESSE).getString(key);
                }
                targetElements.put(key, value);
            }
            return targetElements;
        }
    }
}

