/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.fitnesse.ConvertReport;
import hudson.plugins.fitnesse.FitnesseBuildAction;
import hudson.plugins.fitnesse.FitnesseBuilder;
import hudson.plugins.fitnesse.Resettable;
import hudson.plugins.fitnesse.RunnerWithTimeOut;
import hudson.remoting.Callable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;

public class FitnesseExecutor
implements Serializable {
    private static final long serialVersionUID = 691934300658830569L;
    private static final int SLEEP_MILLIS = 1000;
    private static final int STARTUP_TIMEOUT_MILLIS = 30000;
    private static final int READ_PAGE_TIMEOUT = 10000;
    private final FitnesseBuilder builder;
    private final EnvVars envVars;
    private final TaskListener listener;
    private transient PrintStream logger;
    private String fitnesseTestId = null;
    private static volatile String fitnessePathToJunitResults = null;

    public static synchronized void setFitnessePathToJunitResults(String valuePassed) {
        fitnessePathToJunitResults = valuePassed;
    }

    public static String getFitnessePathToJunitResults() {
        return fitnessePathToJunitResults;
    }

    public FitnesseExecutor(FitnesseBuilder builder, TaskListener listener, EnvVars envVars) {
        this.builder = builder;
        this.listener = listener;
        this.envVars = envVars;
        this.logger = listener.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Launcher launcher, FilePath workspace, Run<?, ?> build) throws InterruptedException, IOException {
        Proc fitnesseProc;
        block15: {
            fitnesseProc = null;
            build.addAction((Action)this.getFitnesseBuildAction(build));
            if (!this.builder.getFitnesseStart() || (fitnesseProc = this.startFitnesse(workspace, launcher)).isAlive() && this.isFitnesseStarted(this.getFitnessePage(build, false))) break block15;
            boolean bl = false;
            this.killProc(fitnesseProc);
            return bl;
        }
        try {
            String junitResultsFileName = this.builder.getFitnessePathToJunitResultsOut(this.envVars);
            FitnesseExecutor.setFitnessePathToJunitResults(junitResultsFileName.trim());
            FilePath junitFilePath = FitnesseExecutor.getJunitFilePath(this.logger, workspace);
            if (junitFilePath != null) {
                try {
                    this.logger.println("Attempt to delete " + junitFilePath);
                    junitFilePath.delete();
                }
                catch (Exception e) {
                    e.printStackTrace(this.logger);
                }
            }
            FilePath resultsFilePath = FitnesseExecutor.getFilePath(this.logger, workspace, this.builder.getFitnessePathToXmlResultsOut(this.envVars));
            URL fitnessePageURL = this.getFitnessePage(build, true);
            boolean interrupted = (Boolean)launcher.getChannel().call((Callable)new ReadAndWriteFitnesseResults(fitnessePageURL, resultsFilePath));
            if (interrupted) {
                throw new InterruptedException("Call for requested fitnesse page was interrupted");
            }
            if (junitFilePath != null) {
                try {
                    this.logger.println("Attempt to convert " + resultsFilePath + " to " + junitFilePath);
                    ConvertReport.generateJunitResult(resultsFilePath, junitFilePath);
                }
                catch (Exception e) {
                    e.printStackTrace(this.logger);
                }
            }
            boolean bl = true;
            this.killProc(fitnesseProc);
            return bl;
        }
        catch (Throwable t) {
            try {
                t.printStackTrace(this.logger);
                try {
                    this.killTest(this.getFitnessePage(build, false));
                }
                catch (Exception e) {
                    this.logger.println("Caught exception while trying to terminate Fitnesse test");
                }
                if (t instanceof InterruptedException) {
                    throw (InterruptedException)t;
                }
                boolean bl = false;
                this.killProc(fitnesseProc);
                return bl;
            }
            catch (Throwable throwable) {
                this.killProc(fitnesseProc);
                throw throwable;
            }
        }
    }

    private FitnesseBuildAction getFitnesseBuildAction(Run<?, ?> build) throws IOException, InterruptedException {
        return new FitnesseBuildAction(this.builder.getFitnesseStart(), this.builder.getFitnesseHost(build, this.envVars), this.builder.getFitnessePort(this.envVars), this.builder.getFitnesseSsl());
    }

    private Proc startFitnesse(FilePath workingDirectory, Launcher launcher) throws IOException, InterruptedException {
        this.logger.println("Starting new Fitnesse instance...");
        Launcher.ProcStarter procStarter = launcher.launch().cmds(this.getJavaCmd(workingDirectory));
        procStarter.pwd(this.getFilePath(workingDirectory, this.builder.getFitnesseJavaWorkingDirectory()));
        procStarter.stdout((OutputStream)this.logger).stderr((OutputStream)this.logger);
        return procStarter.start();
    }

    public ArrayList<String> getJavaCmd(FilePath workingDirectory) throws IOException, InterruptedException {
        String fitnesseJavaOpts;
        Node node;
        JDK jdk;
        String java = null;
        if (!this.builder.getFitnesseJdk(this.envVars).isEmpty() && (jdk = Jenkins.getActiveInstance().getJDK(this.builder.getFitnesseJdk(this.envVars))) != null && (node = Computer.currentComputer().getNode()) != null) {
            jdk = jdk.forNode(node, this.listener);
            java = this.getJavaBinFromjavaHome(workingDirectory, jdk.getHome());
        }
        if (java == null && this.envVars.containsKey((Object)"JAVA_HOME")) {
            java = this.getJavaBinFromjavaHome(workingDirectory, (String)this.envVars.get((Object)"JAVA_HOME"));
        }
        if (java == null) {
            java = "java";
        }
        String[] java_opts = "".equals(fitnesseJavaOpts = this.builder.getFitnesseJavaOpts(this.envVars)) ? new String[]{} : fitnesseJavaOpts.split(" ");
        String absolutePathToFitnesseJar = this.getAbsolutePathToFile(workingDirectory, this.builder.getFitnessePathToJar());
        String[] jar_opts = new String[]{"-jar", absolutePathToFitnesseJar};
        FilePath absolutePathToFitNesseRoot = this.getFilePath(workingDirectory, this.builder.getFitnessePathToRoot());
        String[] fitnesse_opts = new String[]{"-d", absolutePathToFitNesseRoot.getParent().getRemote(), "-r", absolutePathToFitNesseRoot.getName(), "-p", Integer.toString(this.builder.getFitnessePort(this.envVars))};
        String[] addOps = FitnesseExecutor.splitOptions(this.builder.getAdditionalFitnesseOptions());
        String[] fitnesse_opts2 = new String[fitnesse_opts.length + addOps.length];
        System.arraycopy(fitnesse_opts, 0, fitnesse_opts2, 0, fitnesse_opts.length);
        System.arraycopy(addOps, 0, fitnesse_opts2, fitnesse_opts.length, addOps.length);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(java);
        if (java_opts.length > 0) {
            cmd.addAll(Arrays.asList(java_opts));
        }
        cmd.addAll(Arrays.asList(jar_opts));
        cmd.addAll(Arrays.asList(fitnesse_opts2));
        return cmd;
    }

    private String getJavaBinFromjavaHome(FilePath workingDirectory, String javaHome) throws IOException, InterruptedException {
        FilePath javaHomePath = this.getFilePath(workingDirectory, javaHome);
        if (javaHomePath.exists()) {
            return javaHomePath.child("bin").child("java").getRemote();
        }
        return null;
    }

    private static String[] splitOptions(String string) {
        ArrayList<String> addOps = new ArrayList<String>();
        Pattern pattern = Pattern.compile("-{1}[a-z]{1}\\s?[^-]*");
        Matcher m = pattern.matcher(string);
        while (m.find()) {
            String s = m.group();
            addOps.add(s.substring(0, 2).trim());
            addOps.add(s.substring(2, s.length()).trim());
        }
        String[] ret = new String[addOps.size()];
        return addOps.toArray(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFitnesseStarted(URL fitnessePageURL) throws InterruptedException {
        long waitedAlready;
        boolean launched = false;
        this.logger.println("Wait for Fitnesse Server start");
        for (waitedAlready = 0L; waitedAlready < 30000L; waitedAlready += 1000L) {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)fitnessePageURL.openConnection();
                connection.setRequestMethod("GET");
                connection.setReadTimeout(10000);
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    throw new RuntimeException(String.format("Response for page %s is %d", fitnessePageURL, responseCode));
                }
                launched = true;
                break;
            }
            catch (IOException e) {
                this.logger.print('.');
                this.logger.flush();
                Thread.sleep(1000L);
                launched = false;
                continue;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        this.logger.printf(launched ? "%nFitnesse server started in %sms.%n" : "%nFitnesse server NOT started in %sms on URL: %s%n", waitedAlready, fitnessePageURL);
        return launched;
    }

    private void killProc(Proc proc) {
        if (proc != null) {
            try {
                proc.kill();
                for (int i = 0; i < 4; ++i) {
                    if (!proc.isAlive()) continue;
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace(this.logger);
            }
        }
    }

    private void killTest(URL url) throws IOException, MalformedURLException {
        if (this.fitnesseTestId == null) {
            return;
        }
        this.logger.println("Attempting to stop Fitnesse test with id " + this.fitnesseTestId);
        URL pageStopTarget = new URL(url.toString().split("\\?")[0] + "?stoptest&id=" + this.fitnesseTestId);
        HttpURLConnection connection = (HttpURLConnection)pageStopTarget.openConnection();
        connection.setReadTimeout(5000);
        this.logger.println("Stop test result: " + connection.getResponseCode() + "/" + connection.getResponseMessage());
    }

    private boolean readAndWriteFitnesseResults(final URL readFromURL, final FilePath writeToFilePath) {
        this.logger = this.listener.getLogger();
        final RunnerWithTimeOut runnerWithTimeOut = new RunnerWithTimeOut(this.builder.getFitnesseTestTimeout(this.envVars));
        Runnable readAndWriteResults = new Runnable(){

            @Override
            public void run() {
                try {
                    writeToFilePath.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                byte[] bytes = FitnesseExecutor.this.getHttpBytes(readFromURL, runnerWithTimeOut, FitnesseExecutor.this.builder.getFitnesseHttpTimeout(FitnesseExecutor.this.envVars));
                FitnesseExecutor.this.writeFitnesseResults(writeToFilePath, bytes);
            }
        };
        try {
            runnerWithTimeOut.run(readAndWriteResults);
        }
        catch (InterruptedException ie) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHttpBytes(URL pageCmdTarget, Resettable timeout, int httpTimeout) {
        InputStream inputStream = null;
        ByteArrayOutputStream bucket = new ByteArrayOutputStream();
        try {
            int lastRead;
            this.logger.println("Connecting to " + pageCmdTarget);
            HttpURLConnection connection = (HttpURLConnection)pageCmdTarget.openConnection();
            if (this.builder.getFitnesseUsername().trim().length() > 0) {
                byte[] message = (this.builder.getFitnesseUsername() + ":" + this.builder.getFitnessePassword()).getBytes("UTF-8");
                String encoded = DatatypeConverter.printBase64Binary((byte[])message);
                connection.setRequestProperty("Authorization", "Basic " + encoded);
            }
            connection.setReadTimeout(httpTimeout);
            this.logger.println("Connection Status: " + connection.getResponseCode() + "/" + connection.getResponseMessage());
            this.fitnesseTestId = connection.getHeaderField("X-FitNesse-Test-Id");
            if (this.fitnesseTestId != null) {
                this.logger.println("Fitnesse-Test-Id: " + this.fitnesseTestId);
            }
            inputStream = connection.getInputStream();
            long recvd = 0L;
            long lastLogged = 0L;
            byte[] buf = new byte[4096];
            while ((lastRead = inputStream.read(buf)) > 0) {
                bucket.write(buf, 0, lastRead);
                timeout.reset();
                if ((recvd += (long)lastRead) - lastLogged <= 1024L) continue;
                this.logger.println(recvd / 1024L + "k...");
                lastLogged = recvd;
            }
            this.fitnesseTestId = null;
        }
        catch (IOException e) {
            e.printStackTrace(this.logger);
        }
        finally {
            if (inputStream != null) {
                try {
                    this.logger.println("Force close of input stream.");
                    inputStream.close();
                }
                catch (Exception e) {
                    this.logger.println("Caught exception while trying to close input stream.");
                }
            }
        }
        return bucket.toByteArray();
    }

    URL getFitnessePage(Run<?, ?> build, boolean withCommand) throws IOException, InterruptedException {
        return new URL(this.builder.getFitnesseSsl() ? "https" : "http", this.builder.getFitnesseHost(build, this.envVars), this.builder.getFitnessePort(this.envVars), withCommand ? this.getFitnessePageCmd() : this.getFitnessePageBase());
    }

    String getFitnessePageBase() {
        String targetPageExpression = this.builder.getFitnesseTargetPage(this.envVars);
        int pos = targetPageExpression.indexOf(63);
        if (pos == -1) {
            pos = targetPageExpression.length();
        }
        int posOfAmp = targetPageExpression.contains("&") ? targetPageExpression.indexOf("&") : pos;
        return "/" + targetPageExpression.substring(0, Math.min(pos, posOfAmp));
    }

    String getFitnessePageCmd() {
        String targetPageExpression = this.builder.getFitnesseTargetPage(this.envVars);
        if (targetPageExpression.contains("?")) {
            return "/" + targetPageExpression + "&format=xml&includehtml";
        }
        int pos = targetPageExpression.indexOf(38);
        if (pos == -1) {
            pos = targetPageExpression.length();
        }
        return String.format("/%1$s?%2$s%3$s", targetPageExpression.substring(0, pos), "suite", targetPageExpression.substring(pos) + "&format=xml&includehtml" + this.getPartitioningDetails());
    }

    private String getPartitioningDetails() {
        String valueToReturn = "";
        int partitionCount = this.builder.getFitnessePartitionCount();
        if (this.builder.getFitnessePartitionEnabled() && partitionCount > 1) {
            int partitionToExecute = this.builder.getFitnessePartitionIndex();
            valueToReturn = "&partitionCount=" + partitionCount + "&partitionIndex=" + partitionToExecute;
            String partitionFileName = this.builder.getFitnessePartitionIndexFile();
            if (partitionFileName.length() > 0) {
                valueToReturn = valueToReturn + "&partitionIndexFile=" + partitionFileName;
            }
        }
        return valueToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFitnesseResults(FilePath resultsFilePath, byte[] results) {
        OutputStream resultsStream = null;
        try {
            resultsStream = resultsFilePath.write();
            resultsStream.write(results);
            this.logger.println("Xml results saved as " + Charset.defaultCharset().displayName() + " to " + resultsFilePath.getRemote());
        }
        catch (IOException e) {
            e.printStackTrace(this.logger);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace(this.logger);
        }
        finally {
            try {
                if (resultsStream != null) {
                    resultsStream.close();
                }
            }
            catch (Exception e) {}
        }
    }

    String getAbsolutePathToFile(FilePath workingDirectory, String fileName) {
        return this.getFilePath(workingDirectory, fileName).getRemote();
    }

    FilePath getFilePath(FilePath workingDirectory, String fileName) {
        return FitnesseExecutor.getFilePath(this.logger, workingDirectory, fileName);
    }

    static FilePath getFilePath(PrintStream logger, FilePath workingDirectory, String fileName) {
        if (workingDirectory != null) {
            FilePath fp = workingDirectory.child(fileName);
            try {
                if (!fp.exists()) {
                    logger.printf("Can't find target file: %s with working directory: %s%n", fileName, workingDirectory);
                }
            }
            catch (Exception e) {
                logger.printf("Can't check if remote file exist: %s%n", e.getMessage());
            }
            return fp;
        }
        logger.println("Warning: working directory is null.");
        File fileNameFile = new File(fileName);
        return new FilePath(fileNameFile);
    }

    static FilePath getJunitFilePath(PrintStream logger, FilePath workingDirectory) {
        String fitnessePathToJunitResults = FitnesseExecutor.getFitnessePathToJunitResults();
        if (fitnessePathToJunitResults == null || !fitnessePathToJunitResults.endsWith(".xml")) {
            return null;
        }
        return FitnesseExecutor.getFilePath(logger, workingDirectory, fitnessePathToJunitResults);
    }

    private final class ReadAndWriteFitnesseResults
    extends MasterToSlaveCallable<Boolean, IOException> {
        private final URL fitnessePageURL;
        private final FilePath resultsFilePath;

        ReadAndWriteFitnesseResults(URL fitnessePageURL, FilePath resultsFilePath) {
            this.fitnessePageURL = fitnessePageURL;
            this.resultsFilePath = resultsFilePath;
        }

        public Boolean call() throws IOException {
            return FitnesseExecutor.this.readAndWriteFitnesseResults(this.fitnessePageURL, this.resultsFilePath);
        }
    }
}

