/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.model.Job;
import hudson.plugins.fitnesse.FitnesseResults;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public class FitnesseHistory {
    private Job<?, ?> owner;
    private Set<String> files;
    public final Map<String, List<String>> pages;
    public final List<FitnesseResults> builds;

    public FitnesseHistory(Job<?, ?> project, Set<String> files, Map<String, List<String>> pages, List<FitnesseResults> builds) {
        this.owner = project;
        this.files = files;
        this.pages = pages;
        this.builds = builds;
    }

    @Exported(visibility=2)
    public String getName() {
        return "FitNesse History";
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this;
    }

    public Job<?, ?> getOwner() {
        return this.owner;
    }

    public Set<String> getFiles() {
        return this.files;
    }

    public List<String> getPages(String file) {
        return this.pages.get(file);
    }

    public List<FitnesseResults> getBuilds() {
        return this.builds;
    }

    public String getResult(String file, String page, FitnesseResults build) {
        for (FitnesseResults childFile : build.getChildResults()) {
            if (!file.equals(childFile.getName())) continue;
            for (FitnesseResults child : childFile.getChildResults()) {
                if (!page.equals(child.getName())) continue;
                if (child.isPassedOverall()) {
                    return "pass";
                }
                if (child.isFailedOverall()) {
                    return "fail";
                }
                return "";
            }
        }
        return "";
    }
}

