/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import com.google.common.collect.Ordering;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.fitnesse.CompoundFitnesseResults;
import hudson.plugins.fitnesse.FitnesseHistory;
import hudson.plugins.fitnesse.FitnesseResults;
import hudson.plugins.fitnesse.FitnesseResultsAction;
import hudson.plugins.fitnesse.NativePageCounts;
import hudson.util.RunList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.StaplerProxy;

public class FitnesseHistoryAction
implements StaplerProxy,
Action {
    private final transient Job<?, ?> project;
    private List<FitnesseResults> builds;
    private Map<String, List<String>> allPages;
    private Set<String> allFiles;

    public FitnesseHistoryAction(Job<?, ?> project2) {
        this.project = project2;
    }

    public Object getTarget() {
        this.extractValues(this.project.getBuilds());
        return new FitnesseHistory(this.project, this.allFiles, this.allPages, this.builds);
    }

    public String getIconFileName() {
        return "/plugin/fitnesse/icons/fitnesselogo-32x32.gif";
    }

    public String getDisplayName() {
        return "FitNesse History";
    }

    public String getUrlName() {
        return "fitnesseHistory";
    }

    public void extractValues(RunList<Run<?, ?>> runList) {
        this.builds = new ArrayList<FitnesseResults>();
        this.allFiles = new HashSet<String>();
        this.allPages = new HashMap<String, List<String>>();
        for (Run build : runList) {
            FitnesseResults result;
            FitnesseResultsAction action = (FitnesseResultsAction)build.getAction(FitnesseResultsAction.class);
            if (action == null || (result = action.getResult()).getPageCounts() == null) continue;
            if (!(result instanceof CompoundFitnesseResults)) {
                FitnesseResults fakeResult = new FitnesseResults(new NativePageCounts.Counts("", "", 0, 0, 0, 0, 0, "ALL"));
                fakeResult.addChild(result);
                fakeResult.setOwner(build);
                result = fakeResult;
            }
            this.builds.add(result);
            List<FitnesseResults> childResults = result.getChildResults();
            Set<String> files = FitnesseHistoryAction.extractfiles(childResults);
            this.allFiles.addAll(files);
            Map<String, List<String>> pages = FitnesseHistoryAction.extractPages(childResults);
            for (Map.Entry<String, List<String>> entry : pages.entrySet()) {
                String newFile = entry.getKey();
                List<String> newPages = entry.getValue();
                List<String> existingPages = this.allPages.get(newFile);
                if (existingPages != null) {
                    for (String newPage : newPages) {
                        if (existingPages.contains(newPage)) continue;
                        existingPages.add(newPage);
                    }
                    continue;
                }
                this.allPages.put(newFile, newPages);
            }
        }
    }

    private static Set<String> extractfiles(List<FitnesseResults> results) {
        HashSet<String> files = new HashSet<String>();
        for (FitnesseResults resultFile : results) {
            files.add(resultFile.getName());
        }
        return files;
    }

    static Map<String, List<String>> extractPages(List<FitnesseResults> results) {
        HashMap<String, List<String>> pages = new HashMap<String, List<String>>();
        for (FitnesseResults resultFile : results) {
            HashMap<String, PageInfo> pagesInfo = new HashMap<String, PageInfo>();
            for (FitnesseResults result : resultFile.getChildResults()) {
                PageInfo info = (PageInfo)pagesInfo.get(result.getName());
                if (info == null) {
                    info = new PageInfo(result.getName());
                    pagesInfo.put(result.getName(), info);
                }
                info.recordResult(result);
            }
            pages.put(resultFile.getName(), FitnesseHistoryAction.sorted(pagesInfo));
        }
        return pages;
    }

    private static List<String> sorted(Map<String, PageInfo> map) {
        ArrayList<PageInfo> pages = new ArrayList<PageInfo>(map.values());
        Collections.sort(pages, PageInfo.defaultOrdering());
        ArrayList<String> pagesList = new ArrayList<String>();
        for (PageInfo pageInfo : pages) {
            pagesList.add(pageInfo.page);
        }
        return pagesList;
    }

    private static class PageInfo {
        private final String page;
        private boolean lastResultWasPass = true;
        private int numberOfSwitches = 0;
        private int numberOfOccurrances = 0;

        public PageInfo(String page) {
            this.page = page;
        }

        public void recordResult(FitnesseResults result) {
            if (result.isPassedOverall() || result.isFailedOverall()) {
                ++this.numberOfOccurrances;
                if (this.lastResultWasPass == result.isFailedOverall()) {
                    ++this.numberOfSwitches;
                }
                this.lastResultWasPass = result.isPassedOverall();
            }
        }

        private Integer erraticnessIndex() {
            if (this.numberOfOccurrances == 0) {
                return 0;
            }
            return 100 * this.numberOfSwitches / this.numberOfOccurrances;
        }

        public static Comparator<PageInfo> defaultOrdering() {
            return new ByErraticness().reverse().compound((Comparator)((Object)new ByPage()));
        }

        private static class ByPage
        extends Ordering<PageInfo>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            private ByPage() {
            }

            public int compare(PageInfo o1, PageInfo o2) {
                return o1.page.compareTo(o2.page);
            }
        }

        private static class ByErraticness
        extends Ordering<PageInfo>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            private ByErraticness() {
            }

            public int compare(PageInfo o1, PageInfo o2) {
                return o1.erraticnessIndex().compareTo(o2.erraticnessIndex());
            }
        }
    }
}

