/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.fitnesse.FitnesseBuildAction;
import hudson.plugins.fitnesse.FitnesseResultsAction;
import hudson.plugins.fitnesse.NativePageCounts;
import hudson.plugins.fitnesse.ResultsDetails;
import hudson.tasks.test.TabulatedResult;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public class FitnesseResults
extends TabulatedResult
implements Comparable<FitnesseResults> {
    private static final String DETAILS = "Details";
    private static final String FITNESSE_HOSTNAME = "FITNESSE_HOSTNAME";
    private static final String FITNESSE_PORT = "FITNESSE_PORT";
    private static final long serialVersionUID = 1L;
    private transient List<FitnesseResults> failed;
    private transient List<FitnesseResults> skipped;
    private transient List<FitnesseResults> passed;
    private NativePageCounts.Counts pageCounts;
    private FitnesseResults parent;
    private List<FitnesseResults> details = new ArrayList<FitnesseResults>();
    private transient Run<?, ?> owner;
    private transient TaskListener listener;

    public FitnesseResults(NativePageCounts.Counts pageCounts) {
        this.pageCounts = pageCounts;
    }

    FitnesseResults(NativePageCounts allCounts) {
        this(allCounts.getSummary());
        for (NativePageCounts.Counts detail : allCounts.getDetails()) {
            this.addChild(new FitnesseResults(detail));
        }
    }

    @SuppressFBWarnings(value={"SE_PRIVATE_READ_RESOLVE_NOT_INHERITED"})
    private Object readResolve() {
        if (this.details == null) {
            this.details = new ArrayList<FitnesseResults>();
        }
        return this;
    }

    void addChild(FitnesseResults fitnesseResults) {
        this.details.add(fitnesseResults);
        fitnesseResults.setParent((TestObject)this);
    }

    public TestResult findCorrespondingResult(final String id) {
        if (id.equals(this.getId())) {
            return this;
        }
        List<FitnesseResults> match = this.filteredCopyOfDetails(new ResultsFilter(){

            @Override
            public boolean include(FitnesseResults fitnesseResults) {
                return id.equals(fitnesseResults.getId());
            }
        });
        return match.size() == 0 ? null : (TestResult)match.get(0);
    }

    public void setOwner(Run<?, ?> build) {
        this.owner = build;
    }

    public void setTaskListener(TaskListener listener) {
        this.listener = listener;
    }

    public Run<?, ?> getRun() {
        if (this.owner != null) {
            return this.owner;
        }
        if (this.parent != null) {
            return this.parent.getRun();
        }
        return null;
    }

    public TaskListener getTaskListener() {
        return this.listener;
    }

    public void setParent(TestObject parentObject) {
        this.parent = (FitnesseResults)parentObject;
    }

    public TestObject getParent() {
        return this.parent;
    }

    @Exported(visibility=2)
    public String getName() {
        return Util.escape((String)this.pageCounts.page);
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Exported(visibility=2)
    public int getFailCount() {
        return this.pageCounts.wrong + this.getExceptionCount();
    }

    @Exported(visibility=2)
    public int getFailOnlyCount() {
        return this.pageCounts.wrong;
    }

    @Exported(visibility=2)
    public int getPassCount() {
        return this.pageCounts.right;
    }

    public int getSkipCount() {
        return this.getIgnoredCount();
    }

    @Exported(visibility=2)
    public int getIgnoredCount() {
        return this.pageCounts.ignored;
    }

    @Exported(visibility=2)
    public int getExceptionCount() {
        return this.pageCounts.exceptions;
    }

    public boolean isFailedOverall() {
        return this.getFailCount() > 0 || this.getExceptionCount() > 0;
    }

    public boolean isPassedOverall() {
        return this.isPassed();
    }

    public boolean isPassed() {
        return !this.isFailedOverall() && !this.isSkippedOverall();
    }

    public boolean isSkippedOverall() {
        if (this.isFailedOverall()) {
            return false;
        }
        return this.getPassCount() == 0;
    }

    public Result getBuildResult() {
        if (this.getFailCount() > 0) {
            return Result.UNSTABLE;
        }
        return null;
    }

    @Exported(visibility=2)
    public float getDuration() {
        return (float)this.pageCounts.duration / 1000.0f;
    }

    @Exported(visibility=1)
    public String getResultsDate() {
        return this.pageCounts.resultsDate;
    }

    public boolean isEarlierThan(FitnesseResults other) {
        try {
            return this.pageCounts.resultsDateAsDate().before(other.pageCounts.resultsDateAsDate());
        }
        catch (ParseException e) {
            return false;
        }
    }

    public boolean isLaterThan(FitnesseResults other) {
        try {
            return this.pageCounts.resultsDateAsDate().after(other.pageCounts.resultsDateAsDate());
        }
        catch (ParseException e) {
            return false;
        }
    }

    public long millisAfter(FitnesseResults other) {
        try {
            return this.pageCounts.resultsDateAsDate().getTime() - other.pageCounts.resultsDateAsDate().getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public String getHeadlineText() {
        return this.pageCounts.toString();
    }

    public FitnesseResultsAction getTestResultAction() {
        return this.getParentAction();
    }

    public FitnesseResultsAction getParentAction() {
        Run<?, ?> run = this.getRun();
        if (run != null) {
            FitnesseResultsAction action = (FitnesseResultsAction)run.getAction(FitnesseResultsAction.class);
            return action;
        }
        return null;
    }

    @Override
    public int compareTo(FitnesseResults other) {
        return this.getDisplayName().compareTo(other.getDisplayName());
    }

    public int hashCode() {
        return this.getDisplayName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FitnesseResults other = (FitnesseResults)obj;
        return this.getDisplayName().equals(other.getDisplayName());
    }

    @Exported(visibility=1)
    public Collection<FitnesseResults> getFailedTests() {
        if (this.failed == null) {
            this.failed = this.filteredCopyOfDetails(new ResultsFilter(){

                @Override
                public boolean include(FitnesseResults results) {
                    return results.isFailedOverall();
                }
            });
        }
        return this.failed;
    }

    @Exported(visibility=1)
    public Collection<FitnesseResults> getPassedTests() {
        if (this.passed == null) {
            this.passed = this.filteredCopyOfDetails(new ResultsFilter(){

                @Override
                public boolean include(FitnesseResults results) {
                    return results.isPassedOverall();
                }
            });
        }
        return this.passed;
    }

    @Exported(visibility=1)
    public Collection<FitnesseResults> getSkippedTests() {
        if (this.skipped == null) {
            this.skipped = this.filteredCopyOfDetails(new ResultsFilter(){

                @Override
                public boolean include(FitnesseResults results) {
                    return results.isSkippedOverall();
                }
            });
        }
        return this.skipped;
    }

    private List<FitnesseResults> filteredCopyOfDetails(ResultsFilter countsFilter) {
        ArrayList<FitnesseResults> filteredCopy = new ArrayList<FitnesseResults>();
        for (FitnesseResults result : this.details) {
            if (!countsFilter.include(result)) continue;
            filteredCopy.add(result);
        }
        Collections.sort(filteredCopy);
        return filteredCopy;
    }

    public String toHtml(FitnesseResults results) throws IOException, InterruptedException {
        FitnesseBuildAction buildAction = this.getFitnesseBuildAction();
        return buildAction.getLinkFor(results.getName(), Jenkins.getActiveInstance().getRootUrl());
    }

    public String getDetailsLink() {
        if (this.details == null) {
            return "&nbsp;";
        }
        return String.format("<a href=\"%s/%s\">%s</a>", this.getName(), DETAILS, DETAILS);
    }

    public String getDetailRemoteLink() throws IOException, InterruptedException {
        FitnesseBuildAction buildAction = this.getFitnesseBuildAction();
        return buildAction.getLinkFor(this.getName() + "?pageHistory&resultDate=" + this.getResultsDate(), null, DETAILS);
    }

    public String getRunTestRemoteLink() throws IOException, InterruptedException {
        FitnesseBuildAction buildAction = this.getFitnesseBuildAction();
        String image = "<img class=\"icon-next icon-md\" title=\"Run Test\" src=\"/static/abafcc7b/images/24x24/next.png\" />";
        return buildAction.getLinkFor(this.getName() + "?test", null, image);
    }

    private FitnesseBuildAction getFitnesseBuildAction() throws IOException, InterruptedException {
        FitnesseBuildAction buildAction;
        AbstractBuild owner = this.getOwner();
        if (owner != null) {
            buildAction = (FitnesseBuildAction)owner.getAction(FitnesseBuildAction.class);
            if (buildAction == null) {
                buildAction = this.getDefaultFitnesseBuildAction();
            }
        } else {
            buildAction = this.getDefaultFitnesseBuildAction();
        }
        return buildAction;
    }

    private FitnesseBuildAction getDefaultFitnesseBuildAction() throws IOException, InterruptedException {
        EnvVars envVars;
        AbstractBuild owner = this.getOwner();
        FitnesseBuildAction buildAction = owner != null ? ((envVars = this.getOwner().getEnvironment(this.listener)).containsKey(FITNESSE_HOSTNAME) && envVars.containsKey(FITNESSE_PORT) ? new FitnesseBuildAction(false, (String)envVars.get(FITNESSE_HOSTNAME), Integer.parseInt((String)envVars.get(FITNESSE_PORT))) : FitnesseBuildAction.NULL_ACTION) : FitnesseBuildAction.NULL_ACTION;
        return buildAction;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        TestResult result = this.findCorrespondingResult(token);
        if (result != null) {
            return result;
        }
        return this.findChildByName(token);
    }

    private <T extends TestResult> T findChildByName(String aName) {
        Collection<? extends TestResult> children = this.getChildren();
        for (TestResult testResult : children) {
            if (!aName.equals(testResult.getName())) continue;
            return (T)testResult;
        }
        return null;
    }

    public boolean hasChildren() {
        return this.hasChildResults() || this.hasHtmlContent();
    }

    @Exported(visibility=1)
    public Collection<? extends TestResult> getChildren() {
        if (!this.hasChildren()) {
            return Collections.emptyList();
        }
        ArrayList<FitnesseResults> children = new ArrayList<FitnesseResults>(this.getChildResults());
        if (this.hasHtmlContent()) {
            ResultsDetails htmlContent = new ResultsDetails(this, DETAILS);
            children.add((FitnesseResults)((Object)htmlContent));
        }
        return children;
    }

    protected boolean hasChildResults() {
        return !this.getChildResults().isEmpty();
    }

    protected List<FitnesseResults> getChildResults() {
        return this.details;
    }

    protected boolean hasHtmlContent() {
        return this.pageCounts != null && this.pageCounts.contentFile != null;
    }

    NativePageCounts.Counts getPageCounts() {
        return this.pageCounts;
    }

    static interface ResultsFilter {
        public boolean include(FitnesseResults var1);
    }
}

