/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.Util;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.fitnesse.FitnesseHistoryAction;
import hudson.plugins.fitnesse.FitnesseProjectAction;
import hudson.plugins.fitnesse.FitnesseResults;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerProxy;

public class FitnesseResultsAction
extends AbstractTestResultAction<FitnesseResultsAction>
implements StaplerProxy,
SimpleBuildStep.LastBuildAction {
    private FitnesseResults results;
    private transient List<Action> projectActions;

    protected FitnesseResultsAction(Run<?, ?> owner, FitnesseResults results, TaskListener listener) {
        this.results = results;
        this.results.setOwner(owner);
        this.results.setTaskListener(listener);
        ArrayList<Action> projectActions = new ArrayList<Action>();
        projectActions.add(new FitnesseProjectAction(owner.getParent()));
        projectActions.add(new FitnesseHistoryAction(owner.getParent()));
        this.projectActions = projectActions;
    }

    public int getFailCount() {
        return this.results.getFailCount();
    }

    public int getTotalCount() {
        return this.results.getTotalCount();
    }

    public int getSkipCount() {
        return this.results.getSkipCount();
    }

    public FitnesseResults getResult() {
        return this.results;
    }

    public String getUrlName() {
        return "fitnesseReport";
    }

    public String getDisplayName() {
        return "FitNesse Results";
    }

    public String getIconFileName() {
        return "/plugin/fitnesse/icons/fitnesselogo-32x32.gif";
    }

    public Object getTarget() {
        return this.results;
    }

    public String getSummary() {
        return String.format("(%d pages: %d wrong or with exceptions, %d ignored)", this.getTotalCount(), this.getFailCount(), this.getSkipCount());
    }

    public Collection<? extends Action> getProjectActions() {
        Job job = this.run.getParent();
        if (!Util.filter((List)job.getActions(), FitnesseProjectAction.class).isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<Action> projectActions = new ArrayList<Action>();
        projectActions.add(new FitnesseProjectAction(job));
        projectActions.add(new FitnesseHistoryAction(job));
        this.projectActions = projectActions;
        this.results.setOwner(this.run);
        return this.projectActions;
    }
}

