/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.fitnesse.CompoundFitnesseResults;
import hudson.plugins.fitnesse.FitnesseExecutor;
import hudson.plugins.fitnesse.FitnesseResults;
import hudson.plugins.fitnesse.FitnesseResultsAction;
import hudson.plugins.fitnesse.NativePageCounts;
import hudson.plugins.fitnesse.NativePageCountsParser;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.xml.transform.TransformerException;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FitnesseResultsRecorder
extends Recorder
implements SimpleBuildStep {
    private final String fitnessePathToXmlResultsIn;

    @DataBoundConstructor
    public FitnesseResultsRecorder(String fitnessePathToXmlResultsIn) {
        this.fitnessePathToXmlResultsIn = fitnessePathToXmlResultsIn;
    }

    public String getFitnessePathToXmlResultsIn() {
        return this.fitnessePathToXmlResultsIn;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        try {
            FilePath[] resultFiles = this.getResultFiles(logger, workspace);
            FitnesseResults results = this.getResults(logger, resultFiles, build.getRootDir());
            if (results == null) {
                return;
            }
            FitnesseResultsAction action = new FitnesseResultsAction(build, results, listener);
            if (results.getBuildResult() != null) {
                build.setResult(results.getBuildResult());
            }
            build.addAction((Action)action);
            return;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace(logger);
            build.setResult(Result.FAILURE);
            return;
        }
    }

    private FilePath[] getResultFiles(PrintStream logger, FilePath workspace) throws IOException, InterruptedException {
        return this.getResultFiles1(logger, workspace);
    }

    public FilePath[] getResultFiles1(PrintStream logger, FilePath workingDirectory) throws IOException, InterruptedException {
        FilePath resultsFile = FitnesseExecutor.getFilePath(logger, workingDirectory, this.fitnessePathToXmlResultsIn);
        if (resultsFile.exists()) {
            return new FilePath[]{resultsFile};
        }
        return workingDirectory.list(this.fitnessePathToXmlResultsIn);
    }

    public FitnesseResults getResults(PrintStream logger, FilePath[] resultsFiles, File rootDir) throws IOException, TransformerException, InterruptedException {
        ArrayList<FitnesseResults> resultsList = new ArrayList<FitnesseResults>();
        for (FilePath filePath : resultsFiles) {
            FitnesseResults singleResults = this.getResults(logger, filePath, rootDir);
            resultsList.add(singleResults);
        }
        if (resultsList.isEmpty()) {
            return null;
        }
        if (resultsList.size() == 1) {
            return (FitnesseResults)resultsList.get(0);
        }
        return CompoundFitnesseResults.createFor(resultsList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FitnesseResults getResults(PrintStream logger, FilePath resultsFile, File rootDir) throws IOException, TransformerException, InterruptedException {
        InputStream resultsInputStream = null;
        try {
            logger.println("Reading results as " + Charset.defaultCharset().displayName() + " from " + resultsFile.getRemote());
            resultsInputStream = resultsFile.read();
            Path p = Paths.get(resultsFile.getRemote(), new String[0]);
            String resultFileName = FilenameUtils.getName((String)p.toString());
            logger.println("Parsing results... ");
            NativePageCountsParser pageCountsParser = new NativePageCountsParser();
            NativePageCounts pageCounts = pageCountsParser.parse(resultsInputStream, resultFileName, logger, rootDir.getAbsolutePath() + System.getProperty("file.separator"));
            logger.println("resultsFile: " + this.getFitnessePathToXmlResultsIn());
            logger.println("Got results: " + pageCounts.getSummary());
            FitnesseResults fitnesseResults = new FitnesseResults(pageCounts);
            return fitnesseResults;
        }
        finally {
            if (resultsInputStream != null) {
                try {
                    resultsInputStream.close();
                }
                catch (Exception e) {
                    logger.println("Exception ignored: " + e.getMessage());
                }
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public FormValidation doCheckFitnessePathToXmlResultsIn(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify where to read FitNesse results from.");
            }
            if (!value.endsWith("xml")) {
                return FormValidation.warning((String)"File does not end with 'xml': is that correct?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Publish Fitnesse results report";
        }
    }
}

