/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.fitnesse.FitnesseResults;
import hudson.tasks.test.Messages;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class History {
    private final FitnesseResults testObject;
    private final int graphWidth;
    private final int graphHeight;

    public History(FitnesseResults testObject, int graphWidth, int graphHeight) {
        this.testObject = testObject;
        this.graphWidth = graphWidth;
        this.graphHeight = graphHeight;
    }

    public History(FitnesseResults testObject) {
        this(testObject, 600, 300);
    }

    public boolean historyAvailable() {
        Iterator builds = this.testObject.getRun().getParent().getBuilds().iterator();
        if (!builds.hasNext()) {
            return false;
        }
        builds.next();
        return builds.hasNext();
    }

    public List<FitnesseResults> getList() {
        ArrayList<FitnesseResults> list = new ArrayList<FitnesseResults>();
        for (Run b : this.testObject.getRun().getParent().getBuilds()) {
            FitnesseResults o;
            if (b.isBuilding() || (o = (FitnesseResults)this.testObject.getResultInRun(b)) == null) continue;
            if (o.getOwner() == null) {
                o.setOwner(b);
            }
            list.add(o);
        }
        return list;
    }

    public Graph getDurationGraph() {
        return new GraphImpl("seconds"){

            @Override
            protected DataSetBuilder<String, ChartLabel> createDataSet() {
                DataSetBuilder data = new DataSetBuilder();
                for (FitnesseResults o : History.this.getList()) {
                    data.add((Number)((double)o.getDuration() / 1000.0), (Comparable)((Object)""), (Comparable)new ChartLabel(o){

                        @Override
                        public Color getColor() {
                            if (this.o.getFailCount() > 0) {
                                return ColorPalette.RED;
                            }
                            if (this.o.getSkipCount() > 0) {
                                return ColorPalette.YELLOW;
                            }
                            return ColorPalette.BLUE;
                        }
                    });
                }
                return data;
            }

            @Override
            protected String generateToolTip(ChartLabel label, int row, int column) {
                return label.o.getRun().getDisplayName() + " : " + label.o.getDurationString();
            }
        };
    }

    public Graph getCountGraph() {
        return new GraphImpl("count"){

            @Override
            protected DataSetBuilder<String, ChartLabel> createDataSet() {
                DataSetBuilder data = new DataSetBuilder();
                for (FitnesseResults o : History.this.getList()) {
                    data.add((Number)o.getPassCount(), (Comparable)((Object)"2Passed"), (Comparable)new ChartLabel(o));
                    data.add((Number)o.getFailCount(), (Comparable)((Object)"1Failed"), (Comparable)new ChartLabel(o));
                    data.add((Number)o.getSkipCount(), (Comparable)((Object)"0Skipped"), (Comparable)new ChartLabel(o));
                }
                return data;
            }

            @Override
            protected String generateToolTip(ChartLabel label, int row, int column) {
                String build = label.o.getRun().getDisplayName() + " : ";
                switch (row) {
                    case 0: {
                        return String.valueOf(Messages.AbstractTestResultAction_skip((Object)build, (Object)label.o.getSkipCount()));
                    }
                    case 1: {
                        return String.valueOf(Messages.AbstractTestResultAction_fail((Object)build, (Object)label.o.getFailCount()));
                    }
                }
                return String.valueOf(Messages.AbstractTestResultAction_test((Object)build, (Object)label.o.getTotalCount()));
            }
        };
    }

    class ChartLabel
    implements Comparable<ChartLabel> {
        FitnesseResults o;
        String url;

        public ChartLabel(FitnesseResults o) {
            this.o = o;
            this.url = null;
        }

        public String getUrl() {
            if (this.url == null) {
                this.generateUrl();
            }
            return this.url;
        }

        private void generateUrl() {
            Run<?, ?> build = this.o.getRun();
            String buildLink = build.getUrl();
            String actionUrl = this.o.getTestResultAction().getUrlName();
            this.url = Jenkins.getActiveInstance().getRootUrlFromRequest() + buildLink + actionUrl + this.o.getUrl();
        }

        @Override
        public int compareTo(ChartLabel that) {
            return this.o.getRun().number - that.o.getRun().number;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChartLabel)) {
                return false;
            }
            ChartLabel that = (ChartLabel)o;
            return this.o == that.o;
        }

        public Color getColor() {
            return null;
        }

        public int hashCode() {
            return this.o.hashCode();
        }

        public String toString() {
            String s;
            Run<?, ?> run = this.o.getRun();
            String l = run.getDisplayName();
            String string = s = run instanceof AbstractBuild ? ((AbstractBuild)run).getBuiltOnStr() : null;
            if (s != null) {
                l = l + ' ' + s;
            }
            return l;
        }
    }

    private abstract class GraphImpl
    extends Graph {
        private final String yLabel;

        protected GraphImpl(String yLabel) {
            super(History.this.testObject.getRun().getTimestamp(), History.this.graphWidth, History.this.graphHeight);
            this.yLabel = yLabel;
        }

        protected abstract DataSetBuilder<String, ChartLabel> createDataSet();

        protected abstract String generateToolTip(ChartLabel var1, int var2, int var3);

        protected JFreeChart createGraph() {
            final CategoryDataset dataset = this.createDataSet().build();
            JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)this.yLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setOutlinePaint(null);
            plot.setForegroundAlpha(0.8f);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.black);
            ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
            plot.setDomainAxis((CategoryAxis)domainAxis);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            domainAxis.setLowerMargin(0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            ChartUtil.adjustChebyshev((CategoryDataset)dataset, (NumberAxis)rangeAxis);
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            rangeAxis.setAutoRange(true);
            StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

                public Paint getItemPaint(int row, int column) {
                    ChartLabel key = (ChartLabel)dataset.getColumnKey(column);
                    if (key.getColor() != null) {
                        return key.getColor();
                    }
                    return super.getItemPaint(row, column);
                }

                public String generateURL(CategoryDataset dataset2, int row, int column) {
                    ChartLabel label = (ChartLabel)dataset2.getColumnKey(column);
                    return label.getUrl();
                }

                public String generateToolTip(CategoryDataset dataset2, int row, int column) {
                    ChartLabel label = (ChartLabel)dataset2.getColumnKey(column);
                    return GraphImpl.this.generateToolTip(label, row, column);
                }
            };
            plot.setRenderer((CategoryItemRenderer)ar);
            ar.setSeriesPaint(0, (Paint)ColorPalette.YELLOW);
            ar.setSeriesPaint(1, (Paint)ColorPalette.RED);
            ar.setSeriesPaint(2, (Paint)ColorPalette.BLUE);
            plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
            return chart;
        }
    }
}

