/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class InputStreamDeBOMer {
    static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    static final byte[] UTF32LE_BOM = new byte[]{-1, -2, 0, 0};
    static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    static final byte[] UTF32BE_BOM = new byte[]{0, 0, -2, -1};

    public static InputStream deBOM(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        int skip = InputStreamDeBOMer.skip_bom(UTF8_BOM, bytes);
        if (skip == 0) {
            skip = InputStreamDeBOMer.skip_bom(UTF32LE_BOM, bytes);
        }
        if (skip == 0) {
            skip = InputStreamDeBOMer.skip_bom(UTF16LE_BOM, bytes);
        }
        if (skip == 0) {
            skip = InputStreamDeBOMer.skip_bom(UTF16BE_BOM, bytes);
        }
        if (skip == 0) {
            skip = InputStreamDeBOMer.skip_bom(UTF32BE_BOM, bytes);
        }
        return new ByteArrayInputStream(bytes, skip, bytes.length - skip);
    }

    private static int skip_bom(byte[] bom, byte[] bytes) {
        if (bytes.length < bom.length) {
            return 0;
        }
        for (int i = 0; i < bom.length; ++i) {
            if (bytes[i] == bom[i]) continue;
            return 0;
        }
        return bom.length;
    }
}

