/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class NativePageCounts
extends DefaultHandler {
    public static final String PAGE = "page";
    public static final String PSEUDO_PAGE = "name";
    public static final String CONTENT = "content";
    public static final String APPROX_RESULT_DATE = "approxResultDate";
    public static final String RIGHT = "right";
    public static final String WRONG = "wrong";
    public static final String IGNORED = "ignored";
    public static final String EXCEPTIONS = "exceptions";
    public static final String DURATION = "duration";
    public static final String SUMMARY = "summary";
    public static final String DETAIL = "detail";
    private static final List<String> COUNTABLE = Arrays.asList("summary", "detail");
    private Counts summary;
    private final Map<String, Counts> allCounts = new HashMap<String, Counts>();
    private final String rootDirName;
    private final PrintStream logger;
    private final String resultFileName;

    public NativePageCounts(PrintStream logger, String resultFileName, String rootDirName) {
        this.logger = logger;
        this.rootDirName = rootDirName;
        this.resultFileName = resultFileName;
        logger.println("Write fitnesse results to: " + rootDirName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (COUNTABLE.contains(qName)) {
            String targetPage;
            if (qName.equals(SUMMARY)) {
                targetPage = this.resultFileName;
            } else {
                String page = attributes.getValue(PAGE);
                String pseudoPage = attributes.getValue(PSEUDO_PAGE);
                targetPage = page == null || page.equals("") ? pseudoPage : page;
            }
            String rightStr = attributes.getValue(RIGHT);
            String wrongStr = attributes.getValue(WRONG);
            String ignoredStr = attributes.getValue(IGNORED);
            String exceptionsStr = attributes.getValue(EXCEPTIONS);
            String durationStr = attributes.getValue(DURATION);
            int right = Integer.parseInt(rightStr);
            int wrong = Integer.parseInt(wrongStr);
            int ignored = Integer.parseInt(ignoredStr);
            int exceptions = Integer.parseInt(exceptionsStr);
            int duration = StringUtils.isEmpty((String)durationStr) ? 0 : Integer.parseInt(durationStr);
            String resultsDate = qName.equals(SUMMARY) ? "" : this.resultsDateOf(attributes.getValue(APPROX_RESULT_DATE));
            String contentFileName = this.writeFitnesseResultFiles(targetPage, attributes.getValue(CONTENT));
            Counts counts = new Counts(targetPage, resultsDate, right, wrong, ignored, exceptions, duration, contentFileName);
            this.allCounts.put(counts.page, counts);
            if (qName.equals(SUMMARY)) {
                this.summary = counts;
            }
        }
    }

    public String resultsDateOf(String approxResultDate) {
        int pos = approxResultDate.indexOf(38);
        if (pos == -1) {
            return approxResultDate;
        }
        return approxResultDate.substring(0, pos);
    }

    public int size() {
        return this.allCounts.size();
    }

    public Counts getSummary() {
        List<Counts> details;
        if (this.summary != null && this.summary.right == 0 && this.summary.wrong == 0 && this.summary.ignored == 0 && this.summary.exceptions == 0 && (details = this.getDetails()).size() == 1) {
            return details.get(0);
        }
        return this.summary;
    }

    public Collection<Counts> getAllCounts() {
        return this.allCounts.values();
    }

    public List<Counts> getDetails() {
        ArrayList<Counts> details = new ArrayList<Counts>();
        for (Counts counts : this.allCounts.values()) {
            if (counts == this.summary) continue;
            details.add(counts);
        }
        return details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFitnesseResultFiles(String pageName, String htmlContent) {
        if (null == htmlContent) {
            this.logger.println(" Could not find content for page: " + pageName);
            return null;
        }
        BufferedWriter out = null;
        String fileName = this.buildOutputFileNameToAvoidDuplicates(this.rootDirName + pageName);
        try {
            OutputStreamWriter fstream = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), Charset.forName("ISO-8859-1"));
            out = new BufferedWriter(fstream);
            out.write(htmlContent);
            this.logger.println(" File: " + fileName + " wrote");
            String string = fileName;
            return string;
        }
        catch (IOException e) {
            this.logger.println("Error while writing to out file: " + fileName + "\n" + e.toString());
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logger.println("Could not close out stream: " + fileName + "\n" + e.toString());
                }
            }
        }
        return null;
    }

    private String buildOutputFileNameToAvoidDuplicates(String outputFilePath) {
        int i = 1;
        String outputFileNameWithoutDuplicates = outputFilePath;
        File testOutputFile = new File(outputFilePath);
        while (testOutputFile.exists()) {
            outputFileNameWithoutDuplicates = outputFilePath + "_" + i++;
            testOutputFile = new File(outputFileNameWithoutDuplicates);
        }
        return outputFileNameWithoutDuplicates;
    }

    static final class Counts
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String page;
        public final String resultsDate;
        public final int right;
        public final int wrong;
        public final int ignored;
        public final int exceptions;
        public final int duration;
        public String content;
        public final String contentFile;

        public Counts(String page, String resultsDate, int right, int wrong, int ignored, int exceptions, int duration, String contentFile) {
            this.page = page;
            this.resultsDate = resultsDate;
            this.right = right;
            this.wrong = wrong;
            this.ignored = ignored;
            this.exceptions = exceptions;
            this.duration = duration;
            this.contentFile = contentFile;
        }

        public Date resultsDateAsDate() throws ParseException {
            SimpleDateFormat RESULTS_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
            return RESULTS_DATE_FORMAT.parse(this.resultsDate);
        }

        public String toString() {
            return String.format("%s (%s): %s right, %s wrong, %s ignored, %s exceptions, in %s ms", this.page, this.resultsDate, this.right, this.wrong, this.ignored, this.exceptions, this.duration);
        }
    }
}

