/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.plugins.fitnesse.FitnesseResults;
import hudson.plugins.fitnesse.NativePageCounts;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.kohsuke.stapler.export.Exported;

public class ResultsDetails
extends TestResult {
    private static final long serialVersionUID = 3169974791899027186L;
    private FitnesseResults parentResults;
    private String name;

    public ResultsDetails(FitnesseResults parent, String name) {
        this.parentResults = parent;
        this.name = name;
    }

    private NativePageCounts.Counts getPageCounts() {
        return this.parentResults.getPageCounts();
    }

    public String getName() {
        return Util.escape((String)this.name);
    }

    public String getDisplayName() {
        return "Details";
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.parentResults.getOwner();
    }

    public TestObject getParent() {
        return this.parentResults;
    }

    public AbstractTestResultAction<?> getTestResultAction() {
        return this.parentResults.getTestResultAction();
    }

    public TestResult findCorrespondingResult(String id) {
        if (id.equals(this.getId())) {
            return this;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetailsHtml() {
        StringBuffer ret = new StringBuffer();
        String fileName = this.parentResults.getPageCounts().contentFile;
        if (fileName == null) {
            return "error, content filename is null for page " + this.parentResults.getName();
        }
        BufferedReader br = null;
        try {
            String strLine;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), Charset.forName("ISO-8859-1")));
            while ((strLine = br.readLine()) != null) {
                ret.append(strLine);
            }
        }
        catch (IOException e) {
            String string = "exception while reading file: " + fileName + "\n" + e.toString();
            return string;
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret.toString();
    }

    public int getFailCount() {
        if (!this.isPassed() && !this.isSkipped()) {
            return 1;
        }
        return 0;
    }

    public int getSkipCount() {
        if (this.isSkipped()) {
            return 1;
        }
        return 0;
    }

    public int getPassCount() {
        return this.isPassed() ? 1 : 0;
    }

    public Collection<? extends TestResult> getFailedTests() {
        return this.singletonListOrEmpty(!this.isPassed());
    }

    public Collection<? extends TestResult> getPassedTests() {
        return this.singletonListOrEmpty(this.isPassed());
    }

    public Collection<? extends TestResult> getSkippedTests() {
        return this.singletonListOrEmpty(this.isSkipped());
    }

    private Collection<? extends TestResult> singletonListOrEmpty(boolean f) {
        if (f) {
            return Collections.singletonList(this);
        }
        return Collections.emptyList();
    }

    public boolean isPassed() {
        return this.getPageCounts().exceptions == 0 && this.getPageCounts().wrong == 0;
    }

    @Exported(visibility=9)
    public boolean isSkipped() {
        return this.getPageCounts().ignored > 0 && this.getPageCounts().ignored == this.getNumberOfTestCases();
    }

    private int getNumberOfTestCases() {
        return this.getPageCounts().ignored + this.getPageCounts().exceptions + this.getPageCounts().right + this.getPageCounts().wrong;
    }
}

