/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.plugins.fitnesse.Resettable;

public class RunnerWithTimeOut
implements Resettable {
    static final int POLL_EVERY_MILLIS = 500;
    private final int timeOutMillis;
    private long waitedAlready;

    public RunnerWithTimeOut(int timeoutMillis) {
        this.timeOutMillis = timeoutMillis;
    }

    public void run(Runnable runnable) throws InterruptedException {
        int sleepMillis = this.timeOutMillis < 500 ? this.timeOutMillis : 500;
        this.reset();
        Thread thread = new Thread(runnable);
        thread.start();
        do {
            this.waitedAlready += (long)sleepMillis;
            Thread.sleep(sleepMillis);
        } while (thread.isAlive() && this.waitedAlready < (long)this.timeOutMillis);
        if (thread.isAlive()) {
            thread.interrupt();
            throw new InterruptedException("Waited " + this.waitedAlready + "ms");
        }
    }

    @Override
    public void reset() {
        this.waitedAlready = 0L;
    }
}

