/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.ProxyConfiguration;
import hudson.plugins.git.GitException;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import jenkins.model.Jenkins;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RemoteGitImpl;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGitAPIImpl
implements GitClient,
Serializable {
    protected ProxyConfiguration proxy;

    AbstractGitAPIImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withRepository(RepositoryCallback<T> callable) throws IOException, InterruptedException {
        Repository repo = this.getRepository();
        try {
            T t = callable.invoke(repo, (VirtualChannel)Jenkins.MasterComputer.localChannel);
            return t;
        }
        finally {
            repo.close();
        }
    }

    @Override
    public void commit(String message, PersonIdent author, PersonIdent committer) throws GitException, InterruptedException {
        this.setAuthor(author);
        this.setCommitter(committer);
        this.commit(message);
    }

    @Override
    public void setAuthor(PersonIdent p) {
        if (p != null) {
            this.setAuthor(p.getName(), p.getEmailAddress());
        }
    }

    @Override
    public void setCommitter(PersonIdent p) {
        if (p != null) {
            this.setCommitter(p.getName(), p.getEmailAddress());
        }
    }

    @Override
    public void changelog(String revFrom, String revTo, OutputStream outputStream) throws GitException, InterruptedException {
        this.changelog(revFrom, revTo, new OutputStreamWriter(outputStream));
    }

    @Override
    public void changelog(String revFrom, String revTo, Writer w) throws GitException, InterruptedException {
        this.changelog().excludes(revFrom).includes(revTo).to(w).execute();
    }

    @Override
    public void clone(String url, String origin, boolean useShallowClone, String reference) throws GitException, InterruptedException {
        CloneCommand c = this.clone_().url(url).repositoryName(origin).reference(reference);
        if (useShallowClone) {
            c.shallow();
        }
        c.execute();
    }

    @Override
    public void merge(ObjectId rev) throws GitException, InterruptedException {
        this.merge().setRevisionToMerge(rev).execute();
    }

    protected Object writeReplace() {
        return this.remoteProxyFor((GitClient)Channel.current().export(GitClient.class, (Object)this));
    }

    protected RemoteGitImpl remoteProxyFor(GitClient proxy) {
        return new RemoteGitImpl(proxy);
    }

    @Override
    public void setCredentials(StandardUsernameCredentials cred) {
        this.clearCredentials();
        this.addDefaultCredentials((StandardCredentials)cred);
    }

    @Override
    public void setProxy(ProxyConfiguration proxy) {
        this.proxy = proxy;
    }
}

